package com.xunlei.niux.data.developerplatform.dao;

import com.ferret.common.dao.BaseDaoImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by zhangya on 2016/8/31.
 */
public class DeveloperGamesDaoImpl extends BaseDaoImpl implements DeveloperGamesDao {

    @Override
    public Map<Integer, Integer> getCountByStatus(long infoId,String gameName) {
        String sql = "select count(0) as count ,gamestatus from developer_games where infoId = ? ";
        Object[] args ;
        if(StringUtils.isNotEmpty(gameName)){
            sql +=" and gameName like '%?%'";
            args = new Object[]{infoId, gameName};
        }else {
            args = new Object[]{infoId};
        }
        sql += " group by gamestatus  ";

        final Map<Integer,Integer> map = new HashMap<Integer, Integer>();
        getJdbcTemplate().query(sql, args, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                map.put(rs.getInt("gamestatus"),rs.getInt("count"));
            }
        });
        return map;
    }

}
