package com.xunlei.niux.data.developerplatform.bo;

import com.xunlei.niux.data.developerplatform.dao.DeveloperBusinessInfoDao;
import com.xunlei.niux.data.developerplatform.vo.DeveloperBusinessInfo;
import com.xunlei.niux.data.developerplatform.vo.DeveloperUser;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * Created by zy on 2016/3/3.
 */
@Service
public class DeveloperBusinessInfoBoImpl implements DeveloperBusinessInfoBo {

    @Resource(name = "developerBusinessInfoDao")
    private DeveloperBusinessInfoDao developerBusinessInfoDao;

    @Override
    @Transactional
    public void updateDeveloperBusinessInfo(DeveloperBusinessInfo info, DeveloperUser user) {
        developerBusinessInfoDao.updateDeveloperBusinessInfo(info,user);
    }

    @Override
    @Transactional
    public void insertDeveloperBusinessInfo(DeveloperBusinessInfo info, DeveloperUser user) {
        developerBusinessInfoDao.insertDeveloperBusinessInfo(info,user);
    }

    public DeveloperBusinessInfoDao getDeveloperBusinessInfoDao() {
        return developerBusinessInfoDao;
    }

    public void setDeveloperBusinessInfoDao(DeveloperBusinessInfoDao developerBusinessInfoDao) {
        this.developerBusinessInfoDao = developerBusinessInfoDao;
    }
}
