/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.customer.bo;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.customer.bo.RebateReportBo;
import com.xunlei.niux.data.customer.dto.RebateReportGameDTO;
import com.xunlei.niux.data.customer.dto.RebateReportOldGameDTO;
import com.xunlei.niux.data.customer.dto.RebateReportPersonDTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RebateReportBoImpl
implements RebateReportBo {
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<RebateReportPersonDTO> queryRebateReportPersonByDate(String startDate, String endDate) {
        String sql = "SELECT a.person, a.finished, k.kpi, a.finished/k.kpi*100 AS kpirate FROM \n (SELECT r.person AS person , SUM(r.daymoney) AS finished FROM rebate_report_person r \n WHERE r.reportdate>=? AND r.reportdate<=? GROUP BY r.person) AS a \n LEFT JOIN kpi_person k ON a.person=k.person WHERE k.kpidate=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        params.add(endDate.substring(0, 7));
        return this.baseDao.findBySql(RebateReportPersonDTO.class, sql, params);
    }

    @Override
    public List<RebateReportGameDTO> queryRebateReportGameByDate(String startDate, String endDate) {
        String sql = "SELECT a.gameid, a.finished, k.kpi, a.finished/k.kpi*100 AS kpirate, 0.0 AS payrate FROM \n (SELECT r.gameid AS gameid , SUM(r.daymoney) AS finished FROM rebate_report_game r \n WHERE r.reportdate>=? AND r.reportdate<=? GROUP BY r.gameid) AS a \n LEFT JOIN kpi_game k ON a.gameid=k.gameid WHERE k.kpidate=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        params.add(endDate.substring(0, 7));
        return this.baseDao.findBySql(RebateReportGameDTO.class, sql, params);
    }

    @Override
    public List<RebateReportOldGameDTO> queryRebateReportOldGameByDate(String startDate, String endDate) {
        String sql = "SELECT r.person AS person , SUM(r.daymoney) AS finished, AVG(r.kpitotal) AS kpitotal, AVG(r.kpirate) AS kpirate FROM rebate_report_old_game r \n WHERE r.reportdate>=? AND r.reportdate<=? GROUP BY r.person ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        return this.baseDao.findBySql(RebateReportOldGameDTO.class, sql, params);
    }
}

