/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.util;

import com.ferret.common.dao.annotation.Column;
import com.ferret.common.dao.annotation.Exclude;
import com.ferret.common.dao.enums.Operator;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Order;
import com.ferret.common.dao.vo.Page;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

public class SQLUtil {
    private static final String character = ".";

    public static String createWhere(String alias, Object obj, List<Object> paramList) {
        Field[] fields = obj.getClass().getDeclaredFields();
        StringBuilder where = new StringBuilder();
        for (Field field : fields) {
            if (Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Exclude.class) != null) continue;
            Object value = DaoUtil.getFiledValue((Object)obj, (Field)field);
            Column column = field.getAnnotation(Column.class);
            if ((column == null || !column.emptyQuery()) && (value == null || "".equals(String.valueOf(value)))) continue;
            Operator operator = Operator.EQ;
            if (column != null) {
                operator = column.operator();
            }
            String aliasColumn = alias + character + DaoUtil.getColumnName((Field)field);
            where.append("and ").append(DaoUtil.operatorStatement((String)aliasColumn, (Operator)operator, (Object)value, paramList));
        }
        String whereSql = where.toString();
        if (whereSql.startsWith("and")) {
            whereSql = whereSql.substring(3);
        }
        if (whereSql.length() > 0) {
            whereSql = " where " + whereSql;
        }
        return whereSql;
    }

    public static String createLimit(Page page) {
        if (!page.isPage()) {
            return "";
        }
        int start = (page.getPageNo() - 1) * page.getPageSize();
        return " limit " + start + "," + page.getPageSize();
    }

    public static String createOrder(String alias, Class clazz, Page page) {
        if (!page.isOrder()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List list = page.getOrderList();
        for (Order order : list) {
            Field field = DaoUtil.getDeclaredField((Class)clazz, (String)order.getOrderName());
            String aliasColumn = alias + character + DaoUtil.getColumnName((Field)field);
            sb.append(",").append(aliasColumn);
            if (order.getType() == OrderType.DESC) {
                sb.append(" desc");
                continue;
            }
            sb.append(" asc");
        }
        String orderStr = sb.toString();
        if (orderStr.startsWith(",")) {
            orderStr = orderStr.substring(1);
        }
        if (orderStr.length() > 0) {
            orderStr = " order by " + orderStr;
        }
        return orderStr;
    }
}

