package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.UserLastLoginInfo;
import org.apache.log4j.Logger;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LoginQueryDaoImpl extends BaseDaoImpl implements LoginQueryDao {

    private Logger logger = Logger.getLogger(this.getClass());
    @Override
    public UserLastLoginInfo getUserLastLoginInfoByUid(String uid) {
        String tableName = getTableName(uid);
        String like = uid+"_%";
        String sql = "select  *  from   "+tableName+" where key_id  like  ? and firsttime >0  order  by  firsttime  asc  limit  1";
        logger.info(sql + " [" + uid + "]");
        UserLastLoginInfo info =null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, like);
            rs = ps.executeQuery();
            if (rs.next()) {
                info = new UserLastLoginInfo();
                info.setUid(rs.getString("uid"));
                info.setFirsttime(rs.getDate("firsttime"));
                info.setLasttime(rs.getDate("lasttime"));
            } else {
                logger.error("LoginQueryDaoImpl.getUserLastLoginInfoByUid uid: " + uid +" not record");
            }
        } catch (Exception e){
            logger.error(e);
            return info;
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return info;
    }

    public String getTableName(String uid) {
        long userId = Long.parseLong(uid);
        return String.valueOf("UserGames_"+userId%97);
    }

}
