package com.xunlei.niux.data.vipgame.bo.businesss;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.business.Income;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * @author hezhong
 */
public class IncomeBoImpl implements IncomeBo {
	private static final String SQL = "select 0 as seqid, '000000' as gameid, sum(total) as total,sum(secondprincipal) as secondprincipal,sum(firstprincipal) as firstprincipal,sum(money) as money ,sum(cashVoucher) as cashVoucher, '' as incomemonth, '' as remark from `income` where 1=1 ";

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<Income> find(Income income, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("incomemonth", OrderType.ESC);

        return baseDao.findByObject(Income.class, income, page);

    }

    @Override
    public int count(Income income) {
        return baseDao.count(income);
    }

    @Override
    public Income findById(Integer seqid) {
        return baseDao.findById(Income.class, seqid);
    }

    @Override
    public void update(Income income) {
        baseDao.updateById(income);
    }

    @Override
    public List<Income> findSql(String sql) {
        return baseDao.findBySql(Income.class, sql);
    }

    @Override
    public void insert(Income income) {
        baseDao.insert(income);
    }

    @Override
    public void execute(String sql, List<Object> list) {
        baseDao.execute(sql, list);
    }

	@Override
	public Income queryIncomeForSum(Income income) {
		StringBuilder sb =new StringBuilder(SQL);
		List<Object> params = new ArrayList<Object>();
		if(!StringUtils.isEmpty(income.getGameid())){
			sb.append(" and gameid = ? ");
			params.add(income.getGameid());
		}else{//查全部游戏时，不能汇总订单的金额
			sb.append(" and gameid = ? ");
			params.add("000000");
		}

		if(!StringUtils.isEmpty(income.getIncomemonth())){
			sb.append(" and incomemonth = ? ");
			params.add(income.getIncomemonth());
		}

		if(!StringUtils.isEmpty(income.getFromMonth())){
			sb.append(" and incomemonth >= ? ");
			params.add(income.getFromMonth());
		}

		if(!StringUtils.isEmpty(income.getToMonth())){
			sb.append(" and incomemonth < ? ");
			params.add(income.getToMonth());
		}
		
		List<Income> incomes = baseDao.executeQuery(Income.class, sb.toString(), params);
		
		if(incomes != null && !incomes.isEmpty()){
			return incomes.get(0);
		}
		
		return null;
	}


}
