package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.niux.data.vipgame.vo.SmsSenderInfo;

public class SmsSenderInfoBoImpl  extends BaseDaoImpl implements SmsSenderInfoBo {
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	@Override
	public List<String> findPhoneUnSender(long sid) {
		//分页查找所有的未发送手机号列表
		List<String> unSenderList = new ArrayList<String>();
		SmsSenderInfo smsSenderInfo = new SmsSenderInfo();
		smsSenderInfo.setSid(sid);
		smsSenderInfo.setStatus(0);
		int pageSize =50;
		int count = baseDao.count(smsSenderInfo);
		logger.info("查找手机号暂未发送出去的sid:"+sid+",数据库查询总数："+count);
		int pageNo = count%pageSize==0?count/pageSize: count/pageSize+1;
		for(int i=1;i<=pageNo;i++){
			Page page=new Page();
			page.setPageNo(i);
			page.setPageSize(pageSize);
			List<SmsSenderInfo> list = (List<SmsSenderInfo>)baseDao.findByObject(SmsSenderInfo.class, smsSenderInfo, page);
			if(list!=null && list.size()>0){
				for(SmsSenderInfo uPhone:list){
					unSenderList.add(uPhone.getPhone());
				}
			}
		}
		logger.info("查找手机号暂未发送出去的sid:"+sid+",获取总数："+unSenderList.size());
		return unSenderList;
	}

	@Override
	public void insertUnSender(List<String> phones, long sid) {
         if(phones!=null && phones.size()>0){
        	 long count = this.count(sid);
        	 if(count<phones.size()){ 
        		//先查找是否有插入过数据，如果有则确保唯一性
            	 if(count<=0){
            		 for(String phone:phones){
                		 insert(sid, phone);
                	 }
            	 }else{
            		 for(String phone:phones){
            			 SmsSenderInfo findSSS = this.findObjectBySid(sid, phone);
            			 if(findSSS==null){
            				 insert(sid, phone);
            			 }
                	 } 
            	 }
        	 }
         }
	}

	/**
	 * 插入数据
	 * @param sid
	 * @param phone
	 */
	private void insert(long sid, String phone) {
		SmsSenderInfo ssi = new SmsSenderInfo();
		 ssi.setPhone(phone);
		 ssi.setSid(sid);
		 ssi.setSendTime(DatetimeUtil.now());
		 ssi.setStatus(0);
		 baseDao.insert(ssi);
	}

	


	@Override
	public void updateSenderedStauts(String phone, long sid) {
          String sql = "UPDATE smssenderinfo SET status=?,sendTime=? WHERE phone=? AND sid=?";
          List<Object> paramList = new ArrayList<Object>();
          paramList.add(1);
          paramList.add(DatetimeUtil.now());
          paramList.add(phone);
          paramList.add(sid);
          baseDao.execute(sql, paramList);
		
	}

	@Override
	public long count(long sid) {
		SmsSenderInfo smsSenderInfo = new SmsSenderInfo();
		smsSenderInfo.setSid(sid);
	    int count =  baseDao.count(smsSenderInfo);
		return count;
	}

	@Override
	public SmsSenderInfo findObjectBySid(long sid,String phone) {
       String sql = "SELECT * FROM smssenderinfo WHERE sid=? and phone=?";
       List<Object> paramList = new ArrayList<Object>();
       paramList.add(sid);
       paramList.add(phone);
       List<SmsSenderInfo> list = (List<SmsSenderInfo>)baseDao.executeQuery(SmsSenderInfo.class, sql,paramList);
       if(list!=null && list.size()>0){
    	   return list.get(0);
       }
		return null;
	}

	@Override
	public long countSendered(long sid) {
		SmsSenderInfo smsSenderInfo = new SmsSenderInfo();
		smsSenderInfo.setSid(sid);
		smsSenderInfo.setStatus(1);
	    int count =  baseDao.count(smsSenderInfo);
		return count;
	}




	

}
