package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.CustomerQuery;
import com.xunlei.niux.data.vipgame.vo.CustomerTotal;

public class CustomerQueryBoImpl extends BaseDaoImpl implements CustomerQueryBo {

	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	public int queryForInt(String sql,Object args[]){
		return getJdbcTemplate().queryForInt(sql, args);
	}
	
	@Override
	public int count(CustomerQuery customer) {
		return baseDao.count(customer);
	}

	@Override
	public void deleteById(long id) {
		baseDao.deleteById(CustomerTotal.class, id);
	}

	@Override
	public List<CustomerQuery> find(CustomerQuery customer, Page page) {
		return baseDao.findByObject(CustomerQuery.class, customer, page);
	}
	
	public List<CustomerQuery> find(CustomerQuery customer,String sql,Page page){
		Select select = new Select(customer, page);
		String presql = select.getPreSql();
		if(presql.indexOf("order by")>-1){
			String strs[] = presql.split("order by");
	        sql =  strs[0]+sql+" order by "+strs[1];
		}else{
	        sql =  presql+sql;
		}		
		return findBySql(CustomerQuery.class,sql, select.getParamsList());
	}

	public int count(String sql,Object [] args){
	    return getJdbcTemplate().queryForInt(sql, args);
	}
	
	@Override
	public CustomerQuery findById(long id) {
		return baseDao.findById(CustomerQuery.class, id);
	}

	@Override
	public void insert(CustomerQuery customer) {
		baseDao.insert(customer);
	}

	@Override
	public void update(CustomerQuery customer) {
		baseDao.updateById(customer);
	}
	
	public List findBySql(Class clazz, String preSql, List paramList){
		 return baseDao.findBySql(clazz, preSql, paramList);
	}

}
