package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.UserLastLoginInfo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LoginQueryDaoImpl extends BaseDaoImpl implements LoginQueryDao {

    @Override
    public UserLastLoginInfo getUserLastLoginInfoByUid(String uid) {
        String tableName = getTableName(uid);
        String like = uid+"_%";
        String sql = "select  *  from   "+tableName+" where key_id  like  ?  order  by  firsttime  asc  limit  1";
        UserLastLoginInfo info =null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, like);
            rs = ps.executeQuery();
            if (rs.next()) {
                info = new UserLastLoginInfo();
                info.setUid(rs.getString("uid"));
                info.setFirsttime(rs.getDate("firsttime"));
                info.setLasttime(rs.getDate("lasttime"));
            }
        } catch (Exception e){
            return info;
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return info;
    }

    public String getTableName(String uid) {
        long userId = Long.parseLong(uid);
        return String.valueOf("UserGames_"+userId%97);
    }

}
