package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.util.ObjectMapper;
import com.xunlei.niux.data.vipgame.vo.customer.CustomerVisit;

import java.util.ArrayList;
import java.util.List;

public class CustomerVisitDaoImpl extends BaseDaoImpl implements CustomerVisitDao {

    public CustomerVisit getCustomerVisit(Long uid) {
        String sql = "select * from customervisit where uid = ? order by confirmNum desc limit 1";
        List<Object> params = new ArrayList<Object>();
        params.add(uid);
        List<CustomerVisit> resultList = findBySql(CustomerVisit.class, sql, params);
        if (resultList == null || resultList.size() == 0) {
            return null;
        }
        return resultList.get(0);
    }



    public void addNewVisitRecord(CustomerVisit customerVisit){
        insert(customerVisit);
    }

    public void updateCustomerVisit(CustomerVisit customerVisit){
        String sql = "update customervisit set visitNum = ? where uid = ? ";
        List<Object> params = new ArrayList<Object>();
        params.add(customerVisit.getVisitNum());
        params.add(customerVisit.getUid());
        execute(sql, params);
    }

    public void visitConfirm(CustomerVisit customerVisit) {
        String sql = "update customervisit set confirmNum = ? where uid = ? ";
        List<Object> params = new ArrayList<Object>();
        params.add(customerVisit.getConfirmNum());
        params.add(customerVisit.getUid());
        execute(sql, params);
    }

}
