package com.xunlei.niux.data.vipgame.bo.gift;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by jamesjxin on 14-9-9.
 */
@Service
public class GiftBoImpl implements GiftBo {

    @Resource(name = "BaseDao")
    private BaseDao baseDao;


    @Override
    public Gift getGiftByGiftID(int giftId) {
        if(giftId <= 0){
            return null;
        }

        Gift gift = null;
        String cacheKey = this.getClass().getName()+giftId;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object obj = cacheManager.get(cacheKey);
        if(obj == null){
            gift = getGiftById(giftId);
            if(gift != null){
                cacheManager.put(cacheKey,gift,10);
            }
        }else {
            gift = (Gift)obj;
        }

        return gift;
    }

    private Gift getGiftById(int giftId){
        Gift query = new Gift();
        query.setGiftId((long) giftId);

        List<Gift> giftList =  baseDao.findByObject(Gift.class, query, new Page());
        if(CollectionUtils.isEmpty(giftList)){
            return null;
        }

        return giftList.get(0);
    }
}
