package com.xunlei.niux.data.vipgame.bo.customerService;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.customerService.CsCallerDao;
import com.xunlei.niux.data.vipgame.dto.customerService.CsCallerDTO;
import com.xunlei.niux.data.vipgame.dto.customerService.CsCallerSumDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by zhangya on 2016/12/22.
 */
@Service
public class CsCallerBoImpl implements CsCallerBo {

    @Autowired
   private CsCallerDao csCallerDao;

    @Override
    public List<CsCallerDTO> getCsCallerDTO(CsCallerDTO csCallerDTO, Page page) {

        return csCallerDao.getCsCallerDTO(csCallerDTO,page);
    }

    @Override
    public int getCsCallerDTOCount(CsCallerDTO csCallerDTO) {

        return csCallerDao.getCsCallerDTOCount(csCallerDTO);
    }

    @Override
    public String getLastCallTime(Long userId) {
        return csCallerDao.getLastCallTime(userId);
    }

    @Override
    public List<CsCallerSumDTO> getCsCallerSumDTO(CsCallerSumDTO csCallerSumDTO, Page page) {
        return csCallerDao.getCsCallerSumDTO(csCallerSumDTO,page);
    }

    @Override
    public int getCsCallerSumDTOCount(CsCallerSumDTO csCallerSumDTO) {
        return csCallerDao.getCsCallerSumDTOCount(csCallerSumDTO);
    }

    @Override
    public void deleteCsCallDemandBatch(Long... seqids) {
        csCallerDao.deleteCsCallDemandBatch(seqids);
    }

    @Override
    public void updateLastCallTimeByUid(Long uid, String time) {
        csCallerDao.updateLastCallTimeByUid(uid,time);
    }
}
