package com.xunlei.niux.data.vipgame.bo.activity;

import com.xunlei.niux.data.vipgame.vo.activity.VirtualCard;
/**
 * 虚拟卡。目前支持积分双倍卡和积分半价卡
 * @author 陆建明
 *
 */
public interface VirtualCardBo {
	/**
	 * 发放虚拟卡
	 * 
	 * @param type 卡类型 1:双倍积分卡 2:半价卡 不能为空
	 * @param userId 用户迅雷UID  不能为空
	 * @param orderId 订单号 不能为空
	 * @param orderActNo 领取虚拟卡时的活动编号  不能为空
	 * @return VirtualCard 返回新增的订单 为空表示本次未发放成功
	 * 
	 */
    public VirtualCard giveOut(String type, String userId, String orderId, String actNo, String ip);

	/**
	 * 激活虚拟卡。同一时间不能同时使用多张同一类型卡。
	 * 
	 * @param type 卡类型 1:双倍积分卡 2:半价卡 不能为空
	 * @param userId 用户迅雷UID  不能为空
	 * @param orderActNo 领取虚拟卡时的活动编号  不能为空
	 * @param orderId 订单号  可以为空，为空时随便选择一张卡来激活
	 * @return VirtualCard 返回新增的订单 为空表示本次未发放成功
	 * 
	 */
    public int use(String type, String userId, String actNo, String orderId);
    

	/**
	 * 查询用户是否有虚拟卡。
	 * 
	 * @param type 卡类型 1:双倍积分卡 2:半价卡 不能为空
	 * @param userId 用户迅雷UID  不能为空
	 * @return boolean true:当前用户有已激活卡 false：当前用户无已激活卡
	 * 
	 */
    public boolean check(String type, String userId);
    
    /**
	 * 使虚拟卡失效。
	 * 
	 * @param type 卡类型 1:双倍积分卡 2:半价卡 不能为空
	 * @param userId 用户迅雷UID  不能为空
	 * @param actNo 失效虚拟卡时的活动编号  可以为空
	 * @return boolean true:当前用户有已激活卡 false：当前用户无已激活卡
	 * 
	 */
    public boolean invalid(String type, String userId, String actNo);
}
