package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;


import com.google.common.collect.Lists;
import com.xunlei.niux.data.vipgame.dao.TemplateSchemaResultDao;
import com.xunlei.niux.data.vipgame.vo.TemplateSchemaResult;
import org.apache.commons.lang.StringUtils;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.TempLateSchemaDao;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;

public class TemplateSchemaBoImpl implements TemplateSchemaBo {

	private TempLateSchemaDao tempLateSchemaDao;
//	private TemplateSchemaResultDao templateSchemaResultDao;
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public void setTempLateSchemaDao(TempLateSchemaDao tempLateSchemaDao){
		this.tempLateSchemaDao = tempLateSchemaDao;
	}
	public TempLateSchemaDao getTempLateSchemaDao(){
		return tempLateSchemaDao;
	}

	public int count(TemplateSchema schema) {
		return baseDao.count(schema);
	}

//	private void setFillResults(List<TemplateSchema> schemas) {
//		List<String> schemaIds = Lists.newArrayList();
//		for (TemplateSchema schema : schemas) {
//			schemaIds.add(String.valueOf(schema.getSchemaid()));
//		}
//		List<TemplateSchemaResult> results = templateSchemaResultDao.geTemplateSchemaResultsByIds(schemaIds);
//		setFillResults(schemas, results);
//	}
//
//	private void setFillResults(List<TemplateSchema> schemas, List<TemplateSchemaResult> results) {
//		for (TemplateSchema schema : schemas) {
//			TemplateSchemaResult matchResult = null;
//			for (TemplateSchemaResult result : results) {
//				if (schema.getSchemaid() != null && schema.getSchemaid().equals(result.getSchemaid())) {
//					matchResult = result;
//				}
//			}
//			setFillResult(schema, matchResult);
//		}
//	}
//
//	private void setFillResult(TemplateSchema schema, TemplateSchemaResult result) {
//		if (result != null) {
//			schema.setExecstatus(result.getExecstatus());
//			schema.setExecfailreason(result.getExecfailreason());
//			schema.setExectime(result.getExectime());
//			schema.setIsexecuted(result.getIsexecuted());
//			schema.setSpendtime(result.getSpendtime());
//		}
//		//没记录也要覆盖  使得两边都执行
//		else {
//			schema.setExecstatus(null);
//			schema.setExecfailreason(null);
//			schema.setExectime(null);
//			schema.setIsexecuted(null);
//			schema.setSpendtime(null);
//		}
//	}

	@Override
	public List<TemplateSchema> getTemplatesByIds(String sechemaIds) {
		List<TemplateSchema> schemas = tempLateSchemaDao.geTemplateSchemasByIds(sechemaIds);
//		if (schemas.size() > 0) {
//			setFillResults(schemas);
//		}
		return schemas;
	}


	public void delete(Integer schemaid) {
		baseDao.deleteById(TemplateSchema.class, schemaid);

	}

	public TemplateSchema find(Integer schemaid) {
		TemplateSchema schema = baseDao.findById(TemplateSchema.class, schemaid);
//		if (schema != null) {
//			TemplateSchemaResult schemaResult = baseDao.findById(TemplateSchemaResult.class, schemaid);
//			setFillResult(schema, schemaResult);
//		}
		return schema;
	}

	public List<TemplateSchema> find(TemplateSchema schema) {
		List<TemplateSchema> schemas = baseDao.findByObject(TemplateSchema.class,schema,new Page());
//		if (schemas.size() > 0) {
//			setFillResults(schemas);
//		}
		return schemas;
	}

	public List<TemplateSchema> findWaitExec(String startTime, String endTime) {
		return tempLateSchemaDao.findWaitExec(startTime, endTime);
	}

	public List<TemplateSchema> find(TemplateSchema schema, Page page) {
		List<TemplateSchema> schemas =  baseDao.findByObject(TemplateSchema.class,schema, page);
//		if (schemas.size() > 0) {
//			setFillResults(schemas);
//		}
		return schemas;
	}

	public void insert(TemplateSchema schema) {
		tempLateSchemaDao.insert(schema);
	}

	public void update(TemplateSchema schema) {
//		throw new UnsupportedOperationException("TemplateSchemaBoImpl.update放弃使用, 请使用updateRepeats");
//		TemplateSchemaResult result = templateSchemaResultDao.findById(TemplateSchemaResult.class, schema.getSchemaid());
//		if (result != null) {
//			result.set
//		} else {
		baseDao.updateById(schema);
//		}
	}
	@Override
	public void updateRepeats(TemplateSchema schema) {
		List<Object> paramsList = new ArrayList<Object>();
		StringBuffer preSql = new StringBuffer("update templateschema set execstatus=? ,isexecuted=?,exectime = ?,spendtime=?,execfailreason=? where templateid=?  and isexecuted=0 and schematime<=?");
		paramsList.add(schema.getExecstatus());
		paramsList.add(schema.getIsexecuted());
		paramsList.add(schema.getExectime());
		paramsList.add(schema.getSpendtime());
		paramsList.add(schema.getExecfailreason());
		paramsList.add(schema.getTemplateid());
		paramsList.add(schema.getSchematime());
		if(StringUtils.isNotEmpty(schema.getExt1())){
			preSql.append(" and ext1=?");
			paramsList.add(schema.getExt1());
		}else{
			preSql.append(" and (ext1='' or ext1 is NULL)");
		}
		if(StringUtils.isNotEmpty(schema.getExt2())){
			preSql.append(" and ext2=?");
			paramsList.add(schema.getExt2());
		}else{
			preSql.append(" and (ext2='' or ext2 is NULL)");
		}
		baseDao.execute(preSql.toString(), paramsList);
	}
//	@Override
//	public void updateRepeats(TemplateSchema schema) {
//		Integer id = schema.getSchemaid();
////		TemplateSchemaResult result = templateSchemaResultDao.findById(TemplateSchemaResult.class, id);
//		if (result != null) {
//			List<Object> paramsList = new ArrayList<Object>();
//			StringBuffer preSql = new StringBuffer("update templateschemaresult set execstatus=? ,isexecuted=?,exectime = ?,spendtime=?,execfailreason=? where schemaid=?  and isexecuted=0");
//			paramsList.add(schema.getExecstatus());
//			paramsList.add(schema.getIsexecuted());
//			paramsList.add(schema.getExectime());
//			paramsList.add(schema.getSpendtime());
//			paramsList.add(schema.getExecfailreason());
//			paramsList.add(schema.getSchemaid());
//			baseDao.execute(preSql.toString(), paramsList);
//		} else {
//			result = new TemplateSchemaResult();
//			result.setSchemaid(schema.getSchemaid());
//			result.setExecstatus(schema.getExecstatus());
//			result.setExecfailreason(schema.getExecfailreason());
//			result.setExectime(schema.getExectime());
//			result.setIsexecuted(schema.getIsexecuted());
//			result.setSpendtime(schema.getSpendtime());
//			baseDao.insert(result);
//
////			List<Object> paramsList = new ArrayList<Object>();
////			StringBuffer preSql = new StringBuffer("update templateschema set execstatus=? ,isexecuted=?,exectime = ?,spendtime=?,execfailreason=? where templateid=?  and isexecuted=0 and schematime<=?");
////			paramsList.add(schema.getExecstatus());
////			paramsList.add(schema.getIsexecuted());
////			paramsList.add(schema.getExectime());
////			paramsList.add(schema.getSpendtime());
////			paramsList.add(schema.getExecfailreason());
////			paramsList.add(schema.getTemplateid());
////			paramsList.add(schema.getSchematime());
////			if(StringUtils.isNotEmpty(schema.getExt1())){
////				preSql.append(" and ext1=?");
////				paramsList.add(schema.getExt1());
////			}else{
////				preSql.append(" and (ext1='' or ext1 is NULL)");
////			}
////			baseDao.execute(preSql.toString(), paramsList);
//		}
//	}

//	public void setTemplateSchemaResultDao(TemplateSchemaResultDao templateSchemaResultDao) {
//		this.templateSchemaResultDao = templateSchemaResultDao;
//	}
}
