/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.niux.data.vipgame.bo.SpreadinfoBo;
import com.xunlei.niux.data.vipgame.vo.Flatno;
import com.xunlei.niux.data.vipgame.vo.Spreadinfo;
import com.xunlei.niux.data.vipgame.vo.SpreadinfoBase;
import java.util.ArrayList;
import java.util.List;

public class SpreadinfoBoImpl
implements SpreadinfoBo {
    private BaseDao baseDao;

    @Override
    public int count(Spreadinfo spreadinfo) {
        return this.baseDao.count((Object)spreadinfo);
    }

    @Override
    public List<Flatno> findFlatnoList() {
        return this.baseDao.findBySql(Flatno.class, "SELECT DISTINCT flatno FROM spreadinfo");
    }

    @Override
    public List<SpreadinfoBase> getSpreadinfoBase(String flatno, String spreadTabStart, int startValue, int endValue) {
        ArrayList<Object> param = new ArrayList<Object>();
        String sql = "SELECT * from (\nSELECT *, REPLACE(spreadTab,?,'') as orderNo from spreadinfo_base where flatno=? and spreadTab like ? ) tmp_spreadbase where 1=1 ";
        param.add(String.valueOf(spreadTabStart) + "_");
        param.add(flatno);
        param.add(String.valueOf(spreadTabStart) + "%");
        if (startValue > 0) {
            sql = String.valueOf(sql) + " and  orderNo >= ? ";
            param.add(startValue);
        }
        if (endValue > 0) {
            sql = String.valueOf(sql) + " and orderNo <= ? ";
            param.add(endValue);
        }
        sql = String.valueOf(sql) + " order by orderNo asc ";
        List bySql = this.baseDao.findBySql(SpreadinfoBase.class, sql, param);
        return bySql;
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void insertSpreadInfo(Spreadinfo spreadInfo) {
        this.checkAdvNo(spreadInfo);
        this.baseDao.insert((Object)spreadInfo);
    }

    private void checkAdvNo(Spreadinfo spreadInfo) {
        String advNoStr;
        String jumpurl = spreadInfo.getJumpurl();
        if (!jumpurl.contains(advNoStr = "advNo=" + spreadInfo.getAdvNo())) {
            jumpurl = jumpurl.endsWith("/") ? String.valueOf(jumpurl) + "?" + advNoStr : (jumpurl.endsWith("?") ? String.valueOf(jumpurl) + advNoStr : (!jumpurl.contains("?") ? String.valueOf(jumpurl) + "?" + advNoStr : String.valueOf(jumpurl) + "&" + advNoStr));
            spreadInfo.setJumpurl(jumpurl);
        }
    }

    @Override
    public void deleteSpreadInfo(Spreadinfo spreadinfo) {
        this.baseDao.deleteById(Spreadinfo.class, (Number)spreadinfo.getSeqId());
    }

    @Override
    public Spreadinfo findSpreadInfo(Spreadinfo spreadinfo) {
        Page p = new Page();
        p.addOrder("flatno", OrderType.DESC);
        List list = this.baseDao.findByObject(Spreadinfo.class, (Object)spreadinfo, p);
        if (list.size() > 0) {
            return (Spreadinfo)list.get(0);
        }
        return null;
    }

    @Override
    public Spreadinfo findSpreadInfo(long seqid) {
        return (Spreadinfo)this.baseDao.findById(Spreadinfo.class, (Number)seqid);
    }

    @Override
    public List<Spreadinfo> findSpreadInfoInlist(Spreadinfo spreadinfo, PagedFliper fliper) {
        Page page = new Page();
        page.addOrder("flatno", OrderType.DESC);
        page.addOrder("spreadTab", OrderType.DESC);
        page.addOrder("advNo", OrderType.DESC);
        page.setPageNo(fliper.getPageNo());
        page.setPageSize(fliper.getPageSize());
        return this.baseDao.findByObject(Spreadinfo.class, (Object)spreadinfo, page);
    }

    @Override
    public void updateSpreadinfo(Spreadinfo spreadinfo) {
        this.checkAdvNo(spreadinfo);
        this.baseDao.updateById((Object)spreadinfo);
    }

    @Override
    public void deleteSpreadInfoById(long seqId) {
        this.baseDao.deleteById(Spreadinfo.class, (Number)seqId);
    }
}

