/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.MobileGuildBo;
import com.xunlei.niux.data.vipgame.dao.MobileGuildDao;
import com.xunlei.niux.data.vipgame.dto.GuildGameDto;
import com.xunlei.niux.data.vipgame.dto.MobileGuildSpreadDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildSpread;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildUser;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileGuildBoImpl
implements MobileGuildBo {
    private static final Logger logger = Logger.getLogger((String)MobileGuildBoImpl.class.getName());
    private static final String downloadurl = "http://preloaddown.boxsvr.niu.xunlei.com/webgame/";
    private static final String callbackurl = "http://dy.niu.xunlei.com/guild/speadCallBack.do";
    private static final String apkPath = "/usr/local/htdocs/xlniuxcentersvr2/pack.sh";
    @Autowired
    private MobileGuildDao mobileGuildDao;

    @Override
    public List<GuildGameDto> getGuildGames() {
        return this.mobileGuildDao.getGuildGames();
    }

    @Override
    public List<MobileGuildSpreadDTO> getGuildSpread(long uid, String seqIds, int pageIndex, int pageSize) {
        return this.mobileGuildDao.getGuildSpread(uid, seqIds, pageIndex, pageSize);
    }

    @Override
    public int countGuildSpread(long uid, String seqIds) {
        return this.mobileGuildDao.countGuildSpread(uid, seqIds);
    }

    @Override
    public void packageSpead(long uid, String gameIds) {
        MobileGuildUser user = new MobileGuildUser();
        user.setUserId(uid);
        MobileGuildUser user_db = FacadeFactory.INSTANCE.getBaseSo().findObject(user);
        if (user_db == null) {
            throw new XLRuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        List<MobileGuildSpreadDTO> list = FacadeFactory.INSTANCE.getMobileGuildBo().getGuildInfo(gameIds);
        SimpleDateFormat sft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowStr = sft.format(new Date());
        StringBuffer gameNosb = new StringBuffer();
        StringBuffer apkNamesb = new StringBuffer();
        StringBuffer loginKeysb = new StringBuffer();
        StringBuffer seqIdsb = new StringBuffer();
        ArrayList<MobileGuildSpread> dataList = new ArrayList<MobileGuildSpread>();
        for (MobileGuildSpreadDTO mobileGuildSpreadDTO : list) {
            String guiidApkName = this.getGuiidApkName(mobileGuildSpreadDTO.getApkName(), user_db.getChanelId());
            String url = downloadurl + mobileGuildSpreadDTO.getGameNo() + "/" + (String)guiidApkName;
            MobileGuildSpread spread = this.bulidMobileGuildSpread(mobileGuildSpreadDTO, uid, url, user_db);
            spread.setInputTime(nowStr);
            dataList.add(spread);
            loginKeysb.append(this.getLoginKey(mobileGuildSpreadDTO.getGameId())).append(",");
            gameNosb.append(mobileGuildSpreadDTO.getGameNo()).append(",");
            String apkName = mobileGuildSpreadDTO.getApkName().replace(".apk", "");
            apkNamesb.append(apkName).append(",");
        }
        List<MobileGuildSpread> dataList_db = this.getPackagedSpreadsDb(dataList);
        for (MobileGuildSpread mobileGuildSpread : dataList) {
            boolean flag = false;
            MobileGuildSpread mobileGuildSpread_db = null;
            for (MobileGuildSpread mobileGuildSpread_db1 : dataList_db) {
                if (!mobileGuildSpread.getGameId().equals(mobileGuildSpread_db1.getGameId()) || !mobileGuildSpread.getApkId().equals(mobileGuildSpread_db1.getApkId()) || !mobileGuildSpread.getGuildUserId().equals(mobileGuildSpread_db1.getGuildUserId())) continue;
                mobileGuildSpread_db = mobileGuildSpread_db1;
                flag = true;
                break;
            }
            if (flag) {
                mobileGuildSpread_db.setHasFinished(false);
                mobileGuildSpread_db.setInputTime(nowStr);
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mobileGuildSpread_db);
            } else {
                FacadeFactory.INSTANCE.getBaseSo().addObject(mobileGuildSpread);
                mobileGuildSpread_db = FacadeFactory.INSTANCE.getBaseSo().findObject(mobileGuildSpread);
            }
            if (mobileGuildSpread_db == null) continue;
            seqIdsb.append(mobileGuildSpread_db.getSeqId()).append(",");
        }
        String gameNos = this.subDotStr(gameNosb.toString());
        String apkNames = this.subDotStr(apkNamesb.toString());
        String loginKeys = this.subDotStr(loginKeysb.toString());
        String seqIds = this.subDotStr(seqIdsb.toString());
        String callBack = "http://dy.niu.xunlei.com/guild/speadCallBack.do?seqIds=" + seqIds;
        this.packageSpead(callBack, user_db.getChanelId(), gameNos, apkNames, loginKeys);
    }

    private List<MobileGuildSpread> getPackagedSpreadsDb(List<MobileGuildSpread> dataList) {
        StringBuffer apkIdsStr = new StringBuffer();
        StringBuffer gameidsStr = new StringBuffer();
        StringBuffer uidsStr = new StringBuffer();
        for (MobileGuildSpread mobileGuildSpread : dataList) {
            apkIdsStr.append(mobileGuildSpread.getApkId()).append(",");
            gameidsStr.append("'" + mobileGuildSpread.getGameId() + "'").append(",");
            uidsStr.append(mobileGuildSpread.getGuildUserId()).append(",");
        }
        String apkIds = this.subDotStr(apkIdsStr.toString());
        String gameids = this.subDotStr(gameidsStr.toString());
        String uids = this.subDotStr(uidsStr.toString());
        return this.mobileGuildDao.getPackagedSpreads(apkIds, gameids, uids);
    }

    private void packageSpead(String callBackUrl, String chanelId, String gameNos, String apkNames, String loginKeys) {
        try {
            Runtime.getRuntime().exec("/usr/local/htdocs/xlniuxcentersvr2/pack.sh  " + callBackUrl + "  " + chanelId + "  " + gameNos + "  " + apkNames + "  " + loginKeys);
            logger.info((Object)("packageGuildSpead success callBackUrl=" + callBackUrl + ",chanelId=" + chanelId + ",gameNos=" + gameNos + ",apkNames=" + apkNames + ",loginKeys=" + loginKeys));
        }
        catch (IOException e) {
            logger.error((Object)("packageGuildSpead IOException callBackUrl=" + callBackUrl + ",chanelId=" + chanelId + ",gameNos=" + gameNos + ",apkNames=" + apkNames + ",loginKeys=" + loginKeys));
            e.printStackTrace();
        }
    }

    @Override
    public void updateSpead(String seqIds) {
        List<MobileGuildSpread> list = FacadeFactory.INSTANCE.getMobileGuildBo().getGuildSpread(0L, seqIds);
        for (MobileGuildSpread mobileGuildSpread : list) {
            if (mobileGuildSpread.getHasFinished()) continue;
            mobileGuildSpread.setHasFinished(true);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mobileGuildSpread);
        }
    }

    @Override
    public List<MobileGuildSpread> getGuildSpread(long uid, String seqIds) {
        return this.mobileGuildDao.getGuildSpread(uid, seqIds);
    }

    @Override
    public List<MobileGuildSpreadDTO> getGuildInfo(String gameIds) {
        return this.mobileGuildDao.getGuildGameInfo(gameIds);
    }

    private MobileGuildSpread bulidMobileGuildSpread(MobileGuildSpreadDTO mobileGuildSpreadDTO, long uid, String url, MobileGuildUser user) {
        MobileGuildSpread spread = new MobileGuildSpread();
        spread.setAppVersion(mobileGuildSpreadDTO.getAppVersion());
        spread.setGameId(mobileGuildSpreadDTO.getGameId());
        spread.setAppSize(mobileGuildSpreadDTO.getAppSize());
        spread.setDownloadUrl(url);
        spread.setGuildUserId(uid);
        spread.setPlatform("\u5b89\u5353");
        spread.setChannelId(user.getChanelId());
        spread.setApkId(mobileGuildSpreadDTO.getApkId());
        spread.setHasFinished(false);
        return spread;
    }

    private String getLoginKey(String gameid) {
        GameXmlMeta query = new GameXmlMeta();
        query.setNewgameid(gameid);
        GameXmlMeta meta = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if (meta == null) {
            return null;
        }
        return meta.getLoginKey();
    }

    private String getGuiidApkName(String apkName, String chanelId) {
        String pathName = null;
        apkName = apkName.replace(".apk", "");
        pathName = String.valueOf(apkName) + "_" + chanelId + ".apk";
        return pathName;
    }

    public String getDotStr(String strs) {
        strs = strs.replace("\uff0c", ",");
        String[] spells = strs.split(",");
        StringBuffer sb = new StringBuffer();
        String[] stringArray = spells;
        int n = spells.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (StringUtils.isNotEmpty((String)str)) {
                sb.append("'" + str + "',");
            }
            ++n2;
        }
        strs = sb.toString();
        if (strs.endsWith(",")) {
            strs = strs.substring(0, strs.length() - 1);
        }
        return strs;
    }

    public String subDotStr(String str) {
        if (StringUtils.isNotEmpty((String)str) && str.endsWith(",")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

