/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.GameInsideplaceBo;
import com.xunlei.niux.data.vipgame.dao.GameInsideplaceDao;
import com.xunlei.niux.data.vipgame.vo.GameInsideplace;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

public class GameInsideplaceBoImpl
implements GameInsideplaceBo {
    private GameInsideplaceDao baseDao;

    public GameInsideplaceDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(GameInsideplaceDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<GameInsideplace> find(GameInsideplace gameInsideplace, int start, int limit) {
        Page page = new Page();
        page.setPageNo(start);
        page.setPageSize(limit);
        page.addOrder("displayOrder", OrderType.ESC);
        return this.baseDao.findByObject(GameInsideplace.class, gameInsideplace, page);
    }

    @Override
    public GameInsideplace findById(long seqid) {
        return (GameInsideplace)this.baseDao.findById(GameInsideplace.class, seqid);
    }

    @Override
    public void insert(GameInsideplace gameInsideplace) {
        String titlePid = gameInsideplace.getTitlepid();
        Map<String, String> ids = this.baseDao.getMaxId(titlePid, gameInsideplace.getGameid());
        String titleid = this.getId(titlePid, ids.get("titleid"));
        gameInsideplace.setTitleid(titleid);
        String pOrder = this.baseDao.getOrderIdByTitleId(titlePid, gameInsideplace.getGameid());
        if (pOrder == null) {
            pOrder = "0";
        }
        String order = this.getId(pOrder, ids.get("displayOrder"));
        gameInsideplace.setDisplayOrder(order);
        this.baseDao.insert(gameInsideplace);
    }

    private String getId(String pid, String maxId) {
        if (maxId == null) {
            if ("0".equals(pid)) {
                return "001";
            }
            return String.valueOf(pid) + "001";
        }
        return TitleId.getNextId(maxId);
    }

    @Override
    public void update(GameInsideplace gameInsideplace) {
        this.baseDao.updateById(gameInsideplace);
    }

    @Override
    public int count(GameInsideplace gameInsideplace) {
        return this.baseDao.count(gameInsideplace);
    }

    @Override
    public void delete(long seqid) {
        this.baseDao.deleteById(GameInsideplace.class, seqid);
    }

    @Override
    public boolean exchangeOrder(long seqid, String way) {
        return this.baseDao.exchangeOrder(seqid, way);
    }

    public static enum TitleId {
        ZERO(0, 3),
        FIRST(3, 6),
        SECOND(6, 9);

        private int preLength;
        private int length;

        private TitleId(int preLength, int length) {
            this.preLength = preLength;
            this.length = length;
        }

        public static String getNextId(String id) {
            String next;
            String preId;
            TitleId titleId = TitleId.valueOfId(id);
            if (titleId == null) {
                throw new IllegalArgumentException("\u4e0d\u662f\u6709\u6548\u7684\u6807\u9898ID\uff1a" + id);
            }
            if (titleId.preLength != 0) {
                preId = id.substring(0, titleId.preLength);
                next = id.substring(titleId.preLength);
            } else {
                preId = "";
                next = id;
            }
            int nextLength = titleId.length - titleId.preLength;
            try {
                next = String.valueOf(preId) + TitleId.format(nextLength, TitleId.parse(next) + 1);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("\u4e0d\u662f\u6709\u6548\u7684\u6807\u9898ID\uff1a" + id, e);
            }
            return next;
        }

        private static TitleId valueOfId(String id) {
            int idLength = id.length();
            TitleId tempId = null;
            TitleId[] titleIdArray = TitleId.values();
            int n = titleIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                TitleId titleId = titleIdArray[n2];
                if (titleId.length == idLength) {
                    tempId = titleId;
                    break;
                }
                ++n2;
            }
            return tempId;
        }

        private static String format(int length, int num) {
            String pattern = "";
            while (length-- > 0) {
                pattern = String.valueOf(pattern) + "0";
            }
            DecimalFormat df = new DecimalFormat(pattern);
            return df.format(num);
        }

        private static int parse(String str) throws ParseException {
            String pattern = "";
            int length = str.length();
            while (length-- > 0) {
                pattern = String.valueOf(pattern) + "0";
            }
            DecimalFormat df = new DecimalFormat(pattern);
            return df.parse(str).intValue();
        }
    }
}

