package com.xunlei.niux.data.vipgame.bo;

import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.games.GamesDao;
import com.xunlei.niux.data.vipgame.dto.MobileGameDTO;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.dto.game.KuaiWanGameDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CpsGames;
import com.xunlei.niux.data.vipgame.vo.Games;
import org.springframework.util.CollectionUtils;

import java.util.List;

public class GamesBoImpl implements GamesBo {
    private static final int GAMEIDCOUNT  = 6;

	private GamesDao gamesDao;
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
    public GamesDao getGamesDao() {
        return gamesDao;
    }

    public void setGamesDao(GamesDao gamesDao) {
        this.gamesDao = gamesDao;
    }

    public List<Games> findGames(Games games,int pageno,int limit){
		Page page=new Page();
		page.setPageNo(pageno);
		page.setPageSize(limit);
		page.addOrder("displayOrder", OrderType.DESC);
		return gamesDao.findByObject(Games.class, games, page);
	}
	
	public List<Games> findGames(Games games,Page page){
		return gamesDao.findByObject(Games.class, games, page);
	}
	
	/**
	 * 通过gameid查询游戏信息
	 * @param gameId
	 * @return
	 */
	public Games getGameByGameId(String gameId){
		if(gameId==null||"".equals(gameId)){
			return null;
		}
		Games game=new Games();
		game.setGameId(gameId);
		List<Games> list=gamesDao.findByObject(Games.class, game, new Page());
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	
	public Object getMobileGameByGameId(String gameId){
		Object result = null;
		if(gameId==null||"".equals(gameId)){
			return null;
		}
		// 先尝试从cpsgames表中获取
		CpsGames game=new CpsGames();
		game.setGameId(gameId);
		List<CpsGames> list = gamesDao.findByObject(CpsGames.class, game, new Page());
		if(list != null && list.size() > 0) {
			result = list.get(0);
		} else {
			// 尝试从games表中获取
			 Games games1 = new Games();
			 games1.setGameId(gameId);
	         games1.setClientType(3);//手游
	         Page page = new Page();
	         List<Games> gamesList = FacadeFactory.INSTANCE.getGamesBo().findGames(games1, page);
	         if(gamesList != null && gamesList.size() > 0) {
	        	 result = gamesList.get(0);
	         }
		}
		
		return result;
	}
	
	public int count(Games games){
		return gamesDao.count(games);
	}
	public Games findGamesById(long seqId){
		return gamesDao.findById(Games.class, seqId);
	}
	public void insertGames(Games games){
        gamesDao.insert(games);
	}
	public void updateGames(Games games){
        gamesDao.updateById(games);
	}

    @Override
    public List<GameDTO> queryGamesByKeyWord(String keyWord,int gameType) {
        if(gameType == 1){
            return gamesDao.queryAppGamesByKeyWordAndChanelId(keyWord,"201602247651785032");
        }else {
            return gamesDao.queryWebGamesByKeyWord(keyWord);
        }
    }

    @Override
    public List<GameDTO> getAllValidWebGames() {
        return gamesDao.getAllValidWebGames();
    }

    @Override
    public List<GameDTO> getAllValidAppGames() {
        return gamesDao.getAllValidAppGames();
    }

    @Override
    public List<GameDTO> getAllValidAppGamesByChanelId(String chanelId) {
        return gamesDao.getAllValidAppGamesByChanelId(chanelId);
    }

    @Override
    public List<Games> queryGames(String keyWord,int limit) {
        return gamesDao.queryGames(keyWord,limit);
    }


    @Override
    public Games getCurrentNewstMobileGame() {
        return gamesDao.getCurrentNewstMobileGame();
    }

    /**
     * 查询所有配置过下载地址，已经接入的手游及cps游戏
     */
	@Override
	public List<MobileGameDTO> getAllMobileGames() {
        return gamesDao.getAllMobileGames();
	}

    @Override
    public String getNextNewCpsgameId() {
        long gameId = getMaxIntGameId()+1;
        String id = String.valueOf(gameId);
        int i = id.length();
        String baseId = getBaseId(GAMEIDCOUNT-i);
        return baseId+id;
    }

    @Override
    public List<KuaiWanGameDTO> getKuaiwanWebGames(){
        return gamesDao.getKuaiwanWebGames();
    }

    @Override
    public List<KuaiWanGameDTO> getKuaiwanAppGames(){
        return gamesDao.getKuaiwanAppGames();
    }

    private String getBaseId(int i) {
        StringBuffer sb = new StringBuffer("");
        for (int j = 0; j < i; j++) {
            sb.append("0");
        }
        return sb.toString();
    }

    private synchronized long getMaxIntGameId(){
        String gameId = getMaxGameId();
        return getId(gameId);
    }


    private String getMaxGameId(){
        CpsGames query = new CpsGames();
        Page page = new Page();
        page.addOrder("gameId", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);
        List<CpsGames> gamesList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        if(CollectionUtils.isEmpty(gamesList))return"c000001";
        return gamesList.get(0).getGameId();
    }

    private Long getId(String gameId) {
        gameId = gameId.substring(1);//截取掉前面的字母
        for (int i=gameId.length()-1; i>0; i--) {
            if (gameId.indexOf(getBaseId(i)) != -1) {
                gameId = gameId.substring(getBaseId(i).length() - 1);
                return Long.parseLong(gameId);
            }
        }
        return 0L;
    }
	@Override
	public List<Games> queryHlgGamesByKeyWord(String keyWord) {
		return gamesDao.queryHlgGamesByKeyWord(keyWord);
	}
	
	@Override
	public List<Games> queryHlgWebGamesByKeyWord(String keyWord) {
		return gamesDao.queryHlgWebGamesByKeyWord(keyWord);
	}

    @Override
    public List<Games> getBoxMoreGames(Games games, int type, String[] order,Boolean limitTime) {
        return gamesDao.getBoxMoreGames(games,type,order,limitTime);
    }


    @Override
    public List<Games> queryRecommendHLGGamelist(){
        return gamesDao.queryRecommendHLGGamelist();
    }

    @Override
    public List<Games> queryNewHLGGamelist(){
        return gamesDao.queryNewHLGGamelist();
    }

    @Override
    public List<Games> queryRecommendPhoneGamelist(){
        return gamesDao.queryRecommendPhoneGamelist();
    }
}
