package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dto.GuildGameDto;
import com.xunlei.niux.data.vipgame.dto.MobileGuildSpreadDTO;
import com.xunlei.niux.data.vipgame.util.ObjectMapper;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildSpread;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Dean on 2016/4/21.
 */
public class MobileGuildDaoImpl extends BaseDaoImpl implements MobileGuildDao {


    public List<GuildGameDto> getGuildGames(){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT g.gameId,g.gameName,t.firstSpell,t.outputTime from mobileguildgame t ");
        sql.append(" LEFT JOIN games  g on t.gameId=g.gameId where t.isDel=0 ");
        return getJdbcTemplate().query(sql.toString(),new ObjectMapper(GuildGameDto.class));
    }

    public List<MobileGuildSpreadDTO> getGuildSpread(long uid,String seqIds,int pageIndex,int pageSize){
        StringBuilder sql=new StringBuilder();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT t.appSize, t.appVersion,t.downloadUrl,t.gameId, t.guildUserId, t.inputTime,");
        sql.append("(case WHEN t.hasFinished=1 then '打包成功' else '打包中' end)  hasFinished,");
        sql.append(" t.platform,t.seqId,g.gameName ");
        sql.append(" FROM mobileguildspread t ");
        sql.append(" LEFT JOIN games g ON t.gameId = g.gameId ");
        sql.append(" WHERE 1=1 ");
        if(uid!=0){
            sql.append(" and t.guildUserId = ? ");
            args.add(uid);
        }
        if(StringUtils.isNotEmpty(seqIds)){
            sql.append(" and t.seqId in ( "+seqIds+" ) ");
        }
        sql.append(" order by t.inputTime desc ");
        if(pageIndex>0&&pageSize>0) {
            sql.append(" limit ?,? ");
            int pageStart = (pageIndex - 1) * pageSize < 0 ? 0 : (pageIndex - 1) * pageSize;
            args.add(pageStart);
            args.add(pageSize);
        }
        return getJdbcTemplate().query(sql.toString(),args.toArray(),new ObjectMapper(MobileGuildSpreadDTO.class,false,false));
    }

    public int countGuildSpread(long uid,String seqIds){
        StringBuilder sql=new StringBuilder();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT count(1) ");
        sql.append(" FROM mobileguildspread t ");
        sql.append(" LEFT JOIN games g ON t.gameId = g.gameId ");
        sql.append(" WHERE 1=1 ");
        if(uid!=0){
            sql.append(" and t.guildUserId = ? ");
            args.add(uid);
        }
        if(StringUtils.isNotEmpty(seqIds)){
            sql.append(" and t.seqId in ( "+seqIds+" ) ");
        }
        sql.append(" order by t.inputTime desc ");
        return getJdbcTemplate().queryForInt(sql.toString(),args.toArray());
    }

    public List<MobileGuildSpread> getGuildSpread(long uid,String seqIds){
        StringBuilder sql=new StringBuilder();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT t.seqId, t.guildUserId,t.gameId,t.appVersion, t.appSize, t.platform,t.inputTime,t.downloadUrl,t.hasFinished");
        sql.append(" FROM mobileguildspread t ");
        sql.append(" WHERE 1=1 ");
        if(uid!=0){
            sql.append(" and t.guildUserId = ? ");
            args.add(uid);
        }
        if(StringUtils.isNotEmpty(seqIds)){
            sql.append(" and t.seqId in ( "+seqIds+" ) ");
        }
        sql.append(" order by t.inputTime desc ");
        return findBySql(MobileGuildSpread.class,sql.toString(),args);
    }

    public List<MobileGuildSpreadDTO> getGuildGameInfo(String gameIds){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT t.gameId,t.appVersion,g.gameNo,a.apkName,g.appSize,t.apkId from mobileguildgame t ");
        sql.append(" LEFT JOIN games g on t.gameId=g.gameId LEFT JOIN mobilegameapk a on t.apkId=a.apkId WHERE 1=1 ");
        if(StringUtils.isNotEmpty(gameIds)){
            sql.append(" and t.gameId in ( "+gameIds+" ) ");
        }
       return getJdbcTemplate().query(sql.toString(),new ObjectMapper(MobileGuildSpreadDTO.class,false,false));
    }

    public List<MobileGuildSpread> getPackagedSpreads( String apkIds, String gameids, String uids){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT * from mobileguildspread  where 1=1 ");
        if(StringUtils.isNotEmpty(gameids)){
            sql.append(" and gameId in ( "+gameids+" ) ");
        }
        if(StringUtils.isNotEmpty(uids)){
            sql.append(" and guildUserId in ( "+uids+" ) ");
        }
        if(StringUtils.isNotEmpty(apkIds)){
            sql.append(" and apkId in ( "+apkIds+" ) ");
        }

        return getJdbcTemplate().query(sql.toString(),new ObjectMapper(MobileGuildSpread.class,false,false));
    }

}
