package com.xunlei.niux.data.vipgame.dao.games;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dto.MobileGameDTO;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.vo.Games;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-6-25.
 */
public class GamesDaoImpl extends BaseDaoImpl implements GamesDao{

    @Override
    public List<Games> queryGames(String keyWord,int limit) {
        String sql = "select * from games where gameName like ? and status = '1' ";
          sql += " and (clientType = 0 or clientType = 1) order by inputTime desc limit "+limit;        

        final List<Games> gamesList = new ArrayList<Games>();

        getJdbcTemplate().query(sql, new Object[]{keyWord+"%"}, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                Games game = new Games();
                game.setSeqId(resultSet.getLong("seqId"));
                game.setGameId(resultSet.getString("gameId"));
                game.setGameNo(resultSet.getString("gameNo"));
                game.setGameName(resultSet.getString("gameName"));
                game.setOfficialWebSite(resultSet.getString("officialWebSite"));
                gamesList.add(game);
            }
        });

        return gamesList;
    }

    @Override
    public List<GameDTO> queryWebGamesByKeyWord(String keyWord) {
        String sql = "select gameId,gameNo,gameName,gameFeature,officialWebSite,picUrl,smallPicUrl,gameDesc,'' downLoadUrl,'' downloadNum,'' mulPhotoUrl,'' appSize,displayOrder" +
                " from games where gameName like ? and status = '1' and (clientType = 0 or clientType = 1) ";

        List<Object> list = new ArrayList<Object>();
        list.add("%"+keyWord+"%");
        List<GameDTO> gamesList = executeQuery(GameDTO.class,sql,list);

        return gamesList;
    }

    @Override
    public List<GameDTO> queryAppGamesByKeyWord(String keyWord) {
        String sql = "select games.gameId,games.gameNo,games.gameName,games.gameFeature,games.officialWebSite,games.picUrl,games.smallPicUrl,games.gameDesc,newcommonspreadinfo.shortUrl downLoadUrl,'' downloadNum,newcommonspreadinfo.muliPhotoUrl mulPhotoUrl,displayOrder,'' appSize from games\n" +
                "left join \n" +
                "(select a.* from commonspreadinfo a \n" +
                "inner join \n" +
                "(select gameId,max(seqId) seqId from commonspreadinfo group by gameId) b \n" +
                "on a.gameId = b.gameId and a.seqId = b.seqId\n" +
                ") newcommonspreadinfo\n" +
                " on games.gameId = newcommonspreadinfo.gameId\n" +
                "where gameName like ? and status = '1' and clientType = 3\n" +
                "union \n" +
                "select gameId,gameNo,gameName,gameFeature,'' officialWebSite,picUrl,iconUrl smallPicUrl,gameDesc,downLoadUrl,downloadNum,mulPhotoUrl,displayOrder,cpsSize appSize from cpsgames where gameName like ? and status = 1 order by displayOrder desc;";

        List<Object> list = new ArrayList<Object>();
        list.add("%"+keyWord+"%");
        list.add("%"+keyWord+"%");
        List<GameDTO> gamesList = executeQuery(GameDTO.class,sql,list);

        return gamesList;
    }

    @Override
    public List<GameDTO> getAllValidAppGames() {
        String sql = " select games.gameId,games.gameNo,games.gameName,games.gameFeature,games.officialWebSite,games.picUrl,games.smallPicUrl,games.gameDesc,newcommonspreadinfo.shortUrl downLoadUrl,'' downloadNum,newcommonspreadinfo.muliPhotoUrl mulPhotoUrl,displayOrder,'' appSize from games\n" +
                "inner join \n" +
                "(select a.* from commonspreadinfo a \n" +
                "inner join \n" +
                "(select gameId,max(seqId) seqId from commonspreadinfo group by gameId) b \n" +
                "on a.gameId = b.gameId and a.seqId = b.seqId\n" +
                ") newcommonspreadinfo\n" +
                " on games.gameId = newcommonspreadinfo.gameId\n" +
                "where status = '1' and clientType = 3\n" +
                "union \n" +
                "select gameId,gameNo,gameName,gameFeature,'' officialWebSite,picUrl,iconUrl smallPicUrl,gameDesc,downLoadUrl,downloadNum,mulPhotoUrl,displayOrder,cpsSize appSize from cpsgames where status = 1 order by displayOrder desc;";

        List<Object> list = new ArrayList<Object>();
        List<GameDTO> gamesList = executeQuery(GameDTO.class,sql,list);

        return gamesList;
    }

    @Override
    public List<MobileGameDTO> getAllMobileGames() {
        String sql = "SELECT s1.gameId,s1.gameNo,s1.gameName,s1.gameFeature featureId,s1.gameType typeId,s1.officialWebSite gameOfficialLink,ifnull(s1.smallPicUrl,'') icon,s2.linkurl downloadLink,s2.ext1  downloadNum,s1.displayOrder\n" +
                "FROM games s1 INNER JOIN (SELECT * FROM linkinfo WHERE linklocid='1601') s2\n" +
                "ON s1.gameId = s2.gameidbytuijian\n" +
                "WHERE s1.status=1 AND s1.clientType=3\n" +
                "union\n" +
                "select gameId,gameNo,gameName,gameFeature featureId,'' typdId,'' gameOfficialLink,ifnull(iconUrl,'') icon,downLoadUrl downloadLink,downloadNum,displayOrder\n" +
                "from cpsgames where status = 1\n" +
                "order by displayOrder desc";
        List<Object> list=new ArrayList<Object>();
        List<MobileGameDTO> bplist = executeQuery(MobileGameDTO.class, sql ,list);
        return bplist;
    }

    public Games getCurrentNewstMobileGame(){
        String sql = " select seqId,gameId,gameName,gameNo from games where gameId like '05%' order by gameId desc limit 1;";

        final List<Games> gamesList = new ArrayList<Games>();

        getJdbcTemplate().query(sql,  new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                Games game = new Games();
                game.setSeqId(resultSet.getLong("seqId"));
                game.setGameId(resultSet.getString("gameId"));
                game.setGameNo(resultSet.getString("gameNo"));
                game.setGameName(resultSet.getString("gameName"));

                gamesList.add(game);
            }
        });
        if(CollectionUtils.isEmpty(gamesList)){
            return null;
        }
        return gamesList.get(0);
    }
}
