/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.bo.vic.RebateReportBo;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportGameDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportOldGameDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportPersonDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportTeamDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class RebateReportBoImpl
implements RebateReportBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public Map<String, RebateReportPersonDTO> queryRebateReportPersonByDate(String startDate, String endDate) {
        RebateReportPersonDTO data;
        HashMap<String, RebateReportPersonDTO> map = new HashMap<String, RebateReportPersonDTO>();
        String sql1 = " SELECT SUM(r.money) AS finished, SUM(r.rebatemoney) AS rebatemoney, r.inputBy As person, 0 AS kpi, 0 AS kpiRc, 0 AS kpiYj, 0.0 AS kpirate, 0.0 AS kpiraterc, 0.0 AS kpirateyj, 0.0 as finishedRiChang, 0.0 as finishedYeJi  FROM \n(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \nINNER JOIN rebateapply r ON o.aporderid=r.aporderid \nWHERE (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) and r.workType=1 GROUP BY r.inputBy  ";
        String sql2 = " SELECT SUM(r.money) AS finished, SUM(r.rebatemoney) AS rebatemoney, r.inputBy As person, 0 AS kpi, 0 AS kpiRc, 0 AS kpiYj, 0.0 AS kpirate, 0.0 AS kpiraterc, 0.0 AS kpirateyj, 0.0 as finishedRiChang, 0.0 as finishedYeJi  FROM \n(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \nINNER JOIN rebateapply r ON o.aporderid=r.aporderid \nWHERE (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) and r.workType=2 GROUP BY r.inputBy  ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        List list1 = this.baseDao.findBySql(RebateReportPersonDTO.class, sql1, params);
        List list2 = this.baseDao.findBySql(RebateReportPersonDTO.class, sql2, params);
        for (RebateReportPersonDTO dto : list1) {
            data = new RebateReportPersonDTO();
            data.setPerson(dto.getPerson());
            data.setFinished(dto.getFinished());
            data.setFinishedRiChang(dto.getFinished());
            data.setFinishedYeJi(0.0);
            data.setRebatemoney(dto.getRebatemoney());
            map.put(dto.getPerson(), data);
        }
        for (RebateReportPersonDTO dto : list2) {
            data = (RebateReportPersonDTO)map.get(dto.getPerson());
            if (data == null) {
                data = new RebateReportPersonDTO();
                data.setPerson(dto.getPerson());
                data.setFinished(dto.getFinished());
                data.setFinishedRiChang(0.0);
                data.setFinishedYeJi(dto.getFinished());
                data.setRebatemoney(dto.getRebatemoney());
            } else {
                data.setRebatemoney(data.getRebatemoney() + dto.getRebatemoney());
                data.setFinished(data.getFinished() + dto.getFinished());
                data.setFinishedYeJi(dto.getFinished());
            }
            map.put(data.getPerson(), data);
        }
        return map;
    }

    @Override
    public RebateReportTeamDTO queryRebateReportByDate(String startDate, String endDate) {
        String sql = " SELECT SUM(r.money) AS finished,r.workType, 0.0 as finishedRiChang, 0.0 as finishedYeJi  FROM \n(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \nINNER JOIN rebateapply r ON o.aporderid=r.aporderid \nWHERE (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1)  GROUP BY r.workType order by r.workType";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        List list = this.baseDao.findBySql(RebateReportTeamDTO.class, sql, params);
        RebateReportTeamDTO dto = new RebateReportTeamDTO();
        if (list == null || list.size() != 2) {
            return null;
        }
        dto.setFinished(((RebateReportTeamDTO)list.get(0)).getFinished() + ((RebateReportTeamDTO)list.get(1)).getFinished());
        dto.setFinishedRiChang(((RebateReportTeamDTO)list.get(0)).getFinished());
        dto.setFinishedYeJi(((RebateReportTeamDTO)list.get(1)).getFinished());
        return dto;
    }

    @Override
    public Map<String, Double> queryRebateReportGameByDate(String startDate, String endDate) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        String sql = " SELECT SUM(r.money) AS finished, r.gameid, 0 AS kpisale, 0.0 AS salerate,0 AS kpiincome, 0.0 AS income,0.0 AS incomerate,0.0 AS saleincomerate  FROM \n(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \nINNER JOIN rebateapply r ON o.aporderid=r.aporderid \nWHERE (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) GROUP BY r.gameid ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        List list = this.baseDao.findBySql(RebateReportGameDTO.class, sql, params);
        for (RebateReportGameDTO dto : list) {
            map.put(dto.getGameid(), dto.getFinished());
        }
        return map;
    }

    @Override
    public List<RebateReportOldGameDTO> queryOldGameKpiSumForPerson(String kpiDate) {
        String sql = " SELECT person, SUM(kpi) AS kpitotal, 0.0 AS finished, 0.0 AS kpirate FROM vic_rebate_report_old_game_config WHERE kpiDate=? GROUP BY person ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(kpiDate);
        return this.baseDao.findBySql(RebateReportOldGameDTO.class, sql, params);
    }
}

