package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.CardCount;

public class CardCountBoImpl implements CardCountBo{
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public void insert(CardCount cc) {
		baseDao.insert(cc);
	}

	public void update(CardCount cc) {
		baseDao.updateById(cc);
	}
	public int update_use(CardCount cc){
		if(cc.getActNo() == null||"".equals(cc.getActNo())){
			return 5;//业务编号不存在
		}
		StringBuffer sb = new StringBuffer();
		sb.append("select * from cardcount where actNo=? and cardtype=? for update");
		List<Object> list=new ArrayList<Object>();
		list.add(cc.getActNo());
		list.add(cc.getCardtype().intValue());
		List<CardCount> cclist = baseDao.executeQuery(CardCount.class, sb.toString(), list);
		if(cclist == null || cclist.size()==0){
			return 5;//业务编号不存在
		}
		CardCount cardCount = cclist.get(0);
		cardCount.setLeaveCount(Long.valueOf(cardCount.getLeaveCount().longValue() - 1L));
        cardCount.setUsedCount(Long.valueOf(cardCount.getUsedCount().longValue() + 1L));
        cardCount.setLiveUsedCount(Long.valueOf(cardCount.getLiveUsedCount().longValue() + 1L));
        if(cardCount.getLeaveCount().longValue() < 0){
        	return 14;//该面额达到了领取上限
        }
        baseDao.updateById(cardCount);
        return 0;
	}
	

	public int update_use(String actNo,int cardType,boolean flag){
		if(actNo == null||"".equals(actNo)){
			return 5;//业务编号不存在
		}
		StringBuffer sb = new StringBuffer();
		sb.append("select * from cardcount where actNo=? and cardtype=? for update");
		List<Object> list=new ArrayList<Object>();
		list.add(actNo);
		list.add(cardType);
		List<CardCount> cclist = baseDao.executeQuery(CardCount.class, sb.toString(), list);
		if(cclist == null || cclist.size()==0){
			return 5;//业务编号不存在
		}
		CardCount cardCount = cclist.get(0);
		if(flag){
			cardCount.setLeaveCount(Long.valueOf(cardCount.getLeaveCount().longValue() - 1L));
	        cardCount.setUsedCount(Long.valueOf(cardCount.getUsedCount().longValue() + 1L));
	        cardCount.setLiveUsedCount(Long.valueOf(cardCount.getLiveUsedCount().longValue() + 1L));
	        if(cardCount.getLeaveCount().longValue() < 0){
	        	return 14;//该面额达到了领取上限
	        }
		}else{
			cardCount.setLeaveCount(Long.valueOf(cardCount.getLeaveCount().longValue() + 1L));
	        cardCount.setUsedCount(Long.valueOf(cardCount.getUsedCount().longValue() - 1L));
	        cardCount.setLiveUsedCount(Long.valueOf(cardCount.getLiveUsedCount().longValue() - 1L));
		}
        baseDao.updateById(cardCount);
        return 0;
		
	}
	
	public int count(CardCount cc) {
		return baseDao.count(cc);
	}

	public List<CardCount> find(CardCount cc, Page page) {
		if(cc==null){
			return new ArrayList<CardCount>();
		}
		return baseDao.findByObject(CardCount.class, cc, page);
	}


	public CardCount find(long seqid) {
		return baseDao.findById(CardCount.class, seqid);
	}
	public List executeQuery(Class class1, String sql, List list){
		return baseDao.executeQuery(class1, sql, list);
	}
}
