package com.xunlei.niux.data.vipgame.bo.blockchain.robot;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.blockchain.robot.RobotQqGroup;
import com.xunlei.niux.data.vipgame.vo.blockchain.robot.RobotQqGroupGroup;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class RobotQqGroupBoImpl implements RobotQqGroupBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;

	public void insert(RobotQqGroup bizInfo) {
		baseDao.insert(bizInfo);
	}
	public List<RobotQqGroup> find(RobotQqGroup bizInfo) {
		return find(bizInfo,new Page());
	}
	public List<RobotQqGroup> find(RobotQqGroup bizInfo, Page page) {
		return baseDao.findByObject(RobotQqGroup.class, bizInfo, page);
	}
	public int count(RobotQqGroup bizInfo) {
		return baseDao.count(bizInfo);
	}

	public RobotQqGroup find(Long seqId) {
		return baseDao.findById(RobotQqGroup.class, seqId);
	}

	public RobotQqGroup find(Integer id) {
		RobotQqGroup bizInfo=new RobotQqGroup();
		bizInfo.setGid(id);
		List<RobotQqGroup> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public void update(RobotQqGroup bizInfo) {
		baseDao.updateById(bizInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void deleteById(String seqId) {
		baseDao.deleteById(RobotQqGroup.class, seqId);
	}

}
