package com.xunlei.niux.data.vipgame.dao.reserve;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.reserve.ReserveNewGame;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * Created by xl on 2016/8/19.
 */
public class ReserveNewGameDaoImpl extends BaseDaoImpl implements ReserveNewGameDao  {

    private final static String PICLINKLOCID="285";
    private final static String VIDEOLINKLOCID="287";


    private String getSql4GameInfo(String startTime,String endTime){
        String sql  = "SELECT rng.*,gs.openTime,games.gameType,games.summary,games.gameName,linkinfo.linklocid,linkinfo.linkDesc,linkinfo.picUrl" +
                " FROM reservenewgame rng\n" +
                "LEFT JOIN games on rng.gameId = games.gameId\n" +
                "LEFT JOIN gameservers gs on rng.gameId = gs.gameId and gs.fenQuNum = '1'\n" +
                "LEFT JOIN linkinfo on linkinfo.gameId=rng.gameId and  ( linkinfo.linklocid='"+PICLINKLOCID+"' or linkinfo.linklocid='"+VIDEOLINKLOCID+"' ) " +
                "where rng.status = 1  ";
        if(StringUtils.isNotEmpty(startTime)){
            sql += " and gs.openTime >= ? ";
        }

        if(StringUtils.isNotEmpty(endTime)){
            sql += " and gs.openTime <= ? ";
        }

        sql +=" ORDER BY gs.openTime DESC ,rng.gameId , linkinfo.linklocid, displaysort ";
        return sql;

    }

    private List<Object> getParam4GameInfo(String startTime, String endTime){
        List<Object> param = new ArrayList<Object>();
        if(StringUtils.isNotEmpty(startTime)){
            param.add(startTime);
        }

        if(StringUtils.isNotEmpty(endTime)){
            param.add(endTime);
        }
        return param;
    }

    @Override
    public List<Map<String, Object>> getGameInfo(String startTime, String endTime) {
        String sql = getSql4GameInfo(startTime,endTime);
        List<Object> param = getParam4GameInfo(startTime,endTime);
        final List<Map<String,Object>> list = new ArrayList<Map<String, Object>>();
        getJdbcTemplate().query(sql,param.toArray(), new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                String gameId = null;
                Map<String, Object> objectMap = null;
                int size = list.size()-1;
                if(size!=-1){
                    objectMap = list.get(size);
                    gameId = objectMap.get("gameId")==null?null:(String) objectMap.get("gameId");
                }
                if(gameId==null||!gameId.equals(rs.getString("gameId"))){
                    Map<String,Object> map = new HashMap<String,Object>();
                    map.put("gameId",rs.getString("gameId"));
                    map.put("openTime",rs.getString("openTime"));
                    map.put("summary",rs.getString("summary"));
                    map.put("gameType",rs.getString("gameType"));
                    map.put("gameName",rs.getString("gameName"));
                    map.put("qqGroups",rs.getString("qqGroups"));
                    map.put("ext1",rs.getString("ext1"));
                    map.put("ext2",rs.getString("ext2"));
                    map.put("ext3",rs.getString("ext3"));
                    map.put("ext4",rs.getString("ext4"));
                    map.put("ext5",rs.getString("ext5"));
                    List<Object> videos = new ArrayList<Object>();
                    map.put("videos",videos);

                    if(StringUtils.isNotEmpty(rs.getString("video1"))){
                        videos.add(rs.getString("video1"));
                    }

                    if(StringUtils.isNotEmpty(rs.getString("video2"))){
                        videos.add(rs.getString("video2"));
                    }

                    List<Map<String,Object>> mapList = new ArrayList<Map<String, Object>>();
                    map.put("artwork",mapList);
                    Map<String,Object> linkMap = new HashMap<String ,Object>();
                    mapList.add(linkMap);
                    linkMap.put("linkDesc",rs.getString("linkdesc"));
                    linkMap.put("picUrl",rs.getString("picurl"));
                    list.add(map);
                }else {
                    Map<String,Object> linkMap = new HashMap<String ,Object>();
                    linkMap.put("linkDesc",rs.getString("linkdesc"));
                    linkMap.put("picUrl",rs.getString("picurl"));
                    List<Map<String,Object>> artwork = (List<Map<String,Object>>)objectMap.get("artwork");
                    artwork.add(linkMap);
                }
            }
        });
        return list;
    }

    @Override
    public Map<String, Object> getGameInfo4GameId(String startTime, String endTime) {
        String sql = getSql4GameInfo(startTime,endTime);
        List<Object> param = getParam4GameInfo(startTime,endTime);
        final Map<String,Object> rootMap = new LinkedHashMap<String, Object>();
        getJdbcTemplate().query(sql,param.toArray(), new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                String gameId = rs.getString("gameId");
                if(!rootMap.containsKey(gameId)){
                    Map<String,Object> map = new HashMap<String,Object>();
                    map.put("gameId",rs.getString("gameId"));
                    map.put("openTime",rs.getString("openTime"));
                    map.put("summary",rs.getString("summary"));
                    map.put("gameType",rs.getString("gameType"));
                    map.put("gameName",rs.getString("gameName"));
                    map.put("qqGroups",rs.getString("qqGroups"));
                    map.put("chargePerson",rs.getString("ext1"));
                    map.put("ext4",rs.getString("ext4"));
                    map.put("ext5",rs.getString("ext5"));
                    map.put("month",rs.getString("openTime").substring(5,7));

                    if(StringUtils.isNotEmpty(rs.getString("video1"))){
                        map.put("video",rs.getString("video1"));
                    }

                    List<Object> mapList = new ArrayList< Object>();
                    map.put("artwork",mapList);

                    if(StringUtils.isNotEmpty(rs.getString("pic"))){
                        mapList.add(rs.getString("pic"));
                    }

                    if(StringUtils.isNotEmpty(rs.getString("ext2"))){
                        mapList.add(rs.getString("ext2"));
                    }

                    if(StringUtils.isNotEmpty(rs.getString("ext3"))){
                        mapList.add(rs.getString("ext3"));
                    }

                    rootMap.put(gameId,map);
                }else {
                    String linklocid = rs.getString("linklocid");
                    if(PICLINKLOCID.equals(linklocid)){
                        List<Object> artwork = (List<Object>)((Map<String,Object>)rootMap.get(gameId)).get("artwork");
                        if(artwork.size()<3){
                            artwork.add(rs.getString("picurl"));
                        }
                    }else if(VIDEOLINKLOCID.equals(linklocid)){
                        Map<String, Object> map = (Map<String, Object>) rootMap.get(gameId);
                        if(!map.containsKey("video")){
                            map.put("video",rs.getString("picurl"));
                        }
                    }
                }
            }
        });
        return rootMap;
    }

    @Override
    public Map<String, String> getWebFristOpenTime4GameId() {
        String sql = "SELECT gameservers.* from gameservers \n" +
                "left join games on gameservers.gameId = games.gameId\n" +
                "where games.clientType in ('0','4','5') and gameservers.fenQuNum = '1'";
        List<GameServers> gameServersList = findBySql(GameServers.class, sql);
        Map<String,String > map = new HashMap<String, String>(gameServersList.size());
        for(GameServers servers: gameServersList){
            map.put(servers.getGameId(),servers.getOpenTime());
        }
        return map;
    }
}
