package com.xunlei.niux.data.vipgame.bo.moyu;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuAct;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @author hezhong
 */
public class MoyuActBoImpl implements MoyuActBo {
    private BaseDao baseDao;
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<MoyuAct> find(MoyuAct act, int start, int limit) {
        Page page = new Page();
        page.setPageNo(start);
        page.setPageSize(limit);

        return baseDao.findByObject(MoyuAct.class, act, page);
    }

    @Override
    public MoyuAct findById(String actno) {
        return baseDao.findById(MoyuAct.class, actno);
    }

    @Override
    public void insert(MoyuAct act) {
        baseDao.insert(act);
    }

    @Override
    public void update(MoyuAct act) {
        baseDao.updateById(act);
    }

    @Override
    public int count(MoyuAct act) {
        return baseDao.count(act);
    }

    @Override
    public MoyuAct findInvalid() {
        String now = DATE_FORMAT.format(new Date());

        MoyuAct act = new MoyuAct();
        act.setIsinvalid(false);
        act.setFromValidtime(now);
        act.setToInvalidtime(now);

        List<MoyuAct> list = this.baseDao.findByObject(MoyuAct.class, act, new Page());
        MoyuAct nowAct = null;

        if(list.size() > 0) {
            nowAct = list.get(0);
        }

        return nowAct;
    }

    @Override
    public MoyuAct findInvalid(Date date) {
        String time = DATE_FORMAT.format(date);

        MoyuAct act = new MoyuAct();
        act.setIsinvalid(false);
        act.setFromValidtime(time);
        act.setToInvalidtime(time);

        List<MoyuAct> list = this.baseDao.findByObject(MoyuAct.class, act, new Page());
        MoyuAct dateAct = null;

        if(list.size() > 0) {
            dateAct = list.get(0);
        }

        return dateAct;
    }
}
