package com.xunlei.niux.data.vipgame.bo.blockchain.robot;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.blockchain.robot.RobotMessage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class RobotMessageBoImpl implements RobotMessageBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public void insert(RobotMessage bizInfo) {
		baseDao.insert(bizInfo);
	}
	public List<RobotMessage> find(RobotMessage bizInfo) {
		return find(bizInfo,new Page());
	}
	public List<RobotMessage> find(RobotMessage bizInfo, Page page) {
		return baseDao.findByObject(RobotMessage.class, bizInfo, page);
	}
	public int count(RobotMessage bizInfo) {
		return baseDao.count(bizInfo);
	}

	public RobotMessage find(Long seqId) {
		return baseDao.findById(RobotMessage.class, seqId);
	}

	public void update(RobotMessage bizInfo) {
		baseDao.updateById(bizInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void deleteById(String seqId) {
		baseDao.deleteById(RobotMessage.class, seqId);
	}

}
