package com.xunlei.niux.data.vipgame.bo.businesss;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.business.IntoSystem;

import java.util.List;

/**
 * @author hezhong
 */
public class IntoSystemBoImpl implements IntoSystemBo {
    private BaseDao baseDao;


    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<IntoSystem> find(IntoSystem intoSystem, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("beginmoney", OrderType.ESC);

        return baseDao.findByObject(IntoSystem.class, intoSystem, page);
    }

    @Override
    public int count(IntoSystem intoSystem) {
        return baseDao.count(intoSystem);
    }

    @Override
    public IntoSystem findById(Integer seqid) {
        return baseDao.findById(IntoSystem.class, seqid);
    }

    @Override
    public void insert(IntoSystem intoSystem) {
        baseDao.insert(intoSystem);
    }

    @Override
    public void update(IntoSystem intoSystem) {
        baseDao.updateById(intoSystem);
    }

    @Override
    public void delete(Integer seqid) {
        baseDao.deleteById(IntoSystem.class, seqid);
    }
}
