package com.xunlei.niux.data.vipgame.bo.authority;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.authority.AuthInfo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class AuthInfoBoImpl implements AuthInfoBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public void insert(AuthInfo authInfo) {
		baseDao.insert(authInfo);
	}
	public List<AuthInfo> find(AuthInfo authInfo) {
		return find(authInfo,new Page());
	}
	public List<AuthInfo> find(AuthInfo authInfo, Page page) {
		return baseDao.findByObject(AuthInfo.class, authInfo, page);
	}
	public int count(AuthInfo authInfo) {
		return baseDao.count(authInfo);
	}

	public AuthInfo find(Long seqId) {
		return baseDao.findById(AuthInfo.class, seqId);
	}

	public AuthInfo find(String authId) {
		AuthInfo authInfo=new AuthInfo();
		authInfo.setAuthId(authId);
		List<AuthInfo> list=find(authInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public void update(AuthInfo authInfo) {
		baseDao.updateById(authInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

}
