package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.customer.CustomerVisit;

import java.util.ArrayList;
import java.util.List;

public class CustomerVisitDaoImpl extends BaseDaoImpl implements CustomerVisitDao {

    public Integer getVisitNum(Long uid, String visitDate) {
        String sql = "select visitNum from customervisit where uid = ? and visitDate = ?";
        return getJdbcTemplate().queryForInt(sql, new Object[]{uid, visitDate});
    }

    public void addNewVisitRecord(CustomerVisit customerVisit){
        insert(customerVisit);
    }

    public void updateCustomerVisit(CustomerVisit customerVisit){
        String sql = "update customervisit set visitNum = ? where userId = ?  and visitDate =?";
        List<Object> params = new ArrayList<Object>();
        params.add(customerVisit.getVisitNum());
        params.add(customerVisit.getUid());
        params.add(customerVisit.getVisitDate());
        execute(sql, params);
    }

}
