package com.xunlei.niux.data.vipgame.bo.blockchain.robot;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.blockchain.robot.RobotAnswer;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class RobotAnswerBoImpl implements RobotAnswerBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public void insert(RobotAnswer bizInfo) {
		baseDao.insert(bizInfo);
	}
	public List<RobotAnswer> find(RobotAnswer bizInfo) {
		return find(bizInfo,new Page());
	}
	public List<RobotAnswer> find(RobotAnswer bizInfo, Page page) {
		return baseDao.findByObject(RobotAnswer.class, bizInfo, page);
	}
	public int count(RobotAnswer bizInfo) {
		return baseDao.count(bizInfo);
	}

	public RobotAnswer find(Long seqId) {
		return baseDao.findById(RobotAnswer.class, seqId);
	}

	public RobotAnswer find(Integer id) {
		RobotAnswer bizInfo=new RobotAnswer();
		bizInfo.setId(id);
		List<RobotAnswer> list=find(bizInfo);
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public void update(RobotAnswer bizInfo) {
		baseDao.updateById(bizInfo);
	}


	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void deleteById(String seqId) {
		baseDao.deleteById(RobotAnswer.class, seqId);
	}

}
