package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;

public class LotteryGiftBoImpl extends BaseDaoImpl implements LotteryGiftBo {
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public void update_recharge(LotteryGift gift) {
		StringBuilder sb=new StringBuilder();
		sb.append("select * from lotterygift where seqid=?  for update");
		List<Object> list=new ArrayList<Object>();
		list.add(gift.getSeqid());
		List<LotteryGift> bplist=baseDao.executeQuery(LotteryGift.class, sb.toString(),list);
		LotteryGift bp=(bplist==null||bplist.size()==0)?null:bplist.get(0);
		if(bp==null){
			throw new RuntimeException("奖品不存在");
		}
		bp.setTotalCount(bp.getTotalCount()+gift.getLeftCount());
		bp.setLeftCount(bp.getLeftCount()+gift.getLeftCount());
		if(bp.getLeftCount()<0){
			throw new RuntimeException("可用奖品数不能小于0");
		}
		bp.setEditBy(gift.getEditBy());
		bp.setEditTime(gift.getEditTime());
		baseDao.updateById(bp);
	}

    @Override
    public List<LotteryGift> getValidLotteryGiftListByDisplayOrderDescLimit(String actNo, int limit) {
        LotteryGift query = new LotteryGift();
        query.setActNo(actNo);
        query.setIsValid(true);
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        page.setPageNo(0);
        if(limit > 0){
            page.setPageSize(limit);
        }
        return baseDao.findByObject(LotteryGift.class,query,page);
    }
}
