package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.MemberGift;


public class MemberGiftBoImpl implements MemberGiftBo {
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	/**
	 * 查询会员专属礼包
	 * @param content
	 * @param start
	 * @param limit
	 * @return
	 */
	public List<MemberGift> find(MemberGift wg,int pageNo,int pageSize){
		Page page=new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("inputTime", OrderType.DESC);
		return baseDao.findByObject(MemberGift.class, wg, page);
	}
	public List<MemberGift> findMemberGift(MemberGift wg,Page page){
		return baseDao.findByObject(MemberGift.class, wg, page);
	}
	public MemberGift findMemberGiftById(long seqId){
		return baseDao.findById(MemberGift.class, seqId);
	}
	public int count(MemberGift wg){
		return baseDao.count(wg);
	}
	public void update(MemberGift wg){
		 baseDao.updateById(wg);
	}
	
	/**
	 * 用于外部接口中领取游戏礼包激活码的
	 */
	public int update_count(MemberGift wg){
		if(wg == null||wg.getGiftNo()==null){
			return 1;//参数错误
		}
		String sql = "select * from membergift where giftNo=? for update";
		List<Object> list=new ArrayList<Object>();
		list.add(wg.getGiftNo());
		List<MemberGift> mglist = executeQuery(MemberGift.class,sql,list);
		if(mglist == null ||mglist.size()==0){
			return 2;//礼包在系统中不存在
		}
		MemberGift gift = mglist.get(0);
		gift.setLeaveCount(gift.getLeaveCount() - 1);
		gift.setUsedCount(gift.getUsedCount() + 1);
		if(gift.getLeaveCount() < 0){
			return 3;//达到了领取上线
		}
		baseDao.updateById(wg);
		return 0;//领取成功
	}
	
	public void insert(MemberGift wg) {
		baseDao.insert(wg);
	}
	public void delete(Long seqId) {
		baseDao.deleteById(MemberGift.class, seqId);
	}
	public List executeQuery(Class class1, String sql, List list) {       
		return baseDao.executeQuery(class1, sql, list);
	}
}
