package com.xunlei.niux.data.vipgame.dao;

import java.util.LinkedList;
import java.util.List;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dto.game.GameLoginCountDTO;
import com.xunlei.niux.data.vipgame.vo.Games;


public class NewLoginAccountDaoImpl extends BaseDaoImpl implements NewLoginAccountDao {

	@Override
	public int getNewLoginAccountCount(int fromDate, int toDate, String gameId) {
		String sql = "select sum(login_account_new) from busi_login_account_new where fdate >= ? and fdate <= ? and gameid = ?";
		return getJdbcTemplate().queryForInt(sql, new Object[] { fromDate, toDate, gameId });
	}

	@Override
	public List<GameLoginCountDTO> getTopTotalLoginGames(int fromDate, int toDate, int size) {
		String sql = "select a.gameid,sum(a.lcount) count from (select gameid, login_account_w  lcount from busi_login_account_w union all select gameid, sum(login_account_new)  lcount  from busi_login_account_new  where fdate >=? and fdate <=? group by gameid )a group by gameid   order  by a.lcount desc limit ?";
		
		List<Object> params = new LinkedList<Object>();
		params.add(fromDate);
		params.add(toDate);
		params.add(size);
		
		return executeQuery(GameLoginCountDTO.class, sql, params);
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<String> getTopGames(int date, int size) {
		String sql = "select t.gameid from (select gameid, sum(login_account_new) as count "
				+ "from busi_login_account_new where fdate = ? group by gameid) t order by t.count desc";
		
		List<Object> params = new LinkedList<Object>();
		params.add(date);
		
		if(size > 0) {
			sql += " limit ?";
			params.add(size);
		}
		
		return getJdbcTemplate().queryForList(sql, params.toArray(), String.class);
	}

	@Override
	public List<Games> getTopGamesWithSameFeature(int fromDate, int toDate, int feature, int size) {
		String sql = "select g.* from(select a.gameid,sum(a.lcount) count from (select gameid, login_account_w  lcount from busi_login_account_w union all select gameid, sum(login_account_new)  lcount  from busi_login_account_new  where fdate >=? and fdate <=? group by gameid )a group by gameid) t inner join games g on g.gameId = t.gameid where g.gameFeature = ? "
				+ "order by t.count desc limit ?";
		
		List<Object> params = new LinkedList<Object>();
		params.add(fromDate);
		params.add(toDate);
		params.add(feature);
		params.add(size);
		
		return executeQuery(Games.class, sql, params);
	}
}
