package com.xunlei.niux.data.vipgame.bo.niutip;

import com.xunlei.common.vo.LibClassD;
import com.xunlei.niux.data.vipgame.dao.niutip.NiuTipsDao;
import com.xunlei.niux.data.vipgame.vo.niutip.NiuTipConditions;
import com.xunlei.niux.data.vipgame.vo.niutip.NiuTips;

import java.util.List;

/**
 * Created by xl on 2016/8/9.
 */
public class NiuTipBoImpl implements NiuTipBo {

    private NiuTipsDao niuTipsDao;

    public NiuTipsDao getNiuTipsDao() {
        return niuTipsDao;
    }

    public void setNiuTipsDao(NiuTipsDao niuTipsDao) {
        this.niuTipsDao = niuTipsDao;
    }

    @Override
    public List<LibClassD> getNotInLibClassD(List<LibClassD> libClassDs, Long tipId) {
        return niuTipsDao.getNotInLibClassD(libClassDs,tipId);
    }

    @Override
    public void removeConditions(Long[] conditionIds, Long tipId) {
        niuTipsDao.removeConditions(conditionIds,tipId);
    }

    @Override
    public void addConditions(String[] conditionIds, Long tipId) {
        niuTipsDao.addConditions(conditionIds,tipId);
    }

    @Override
    public List<NiuTips> getEffectNiuTips(String dateTime) {
        return niuTipsDao.getEffectNiuTips(dateTime);
    }

    @Override
    public List<NiuTipConditions> getAllNiuTipConditon(String tipIds) {
        return niuTipsDao.getAllNiuTipConditon(tipIds);
    }

    @Override
    public List<NiuTips> getEffectNiuTipByClientType(String dateTime, String clientType) {
        return niuTipsDao.getEffectNiuTipByClientType(dateTime,clientType);
    }

    @Override
    public int getTipRecordCount(NiuTips niuTips, Long userId,String displayPage) {
        return niuTipsDao.getTipRecordCount(niuTips,userId,displayPage);
    }
}
