package com.xunlei.niux.data.vipgame.dao.boxThree;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.RowCallbackHandler;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.dto.BonusChargeUserDetailDTO;
import com.xunlei.niux.data.vipgame.dto.BoxBonusChargeRecordDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;

public class BoxBonusChargeRecordDaoImpl extends BaseDaoImpl implements BoxBonusChargeRecordDao {
	
	private BaseSo baseSo;
	
	@Override
	public List<BoxBonusChargeRecordDTO> getBonusChargeRecordList(
			BoxBonusChargeRecordDTO query, int pageNo, int pageSize) {
		List<Object> list = new ArrayList<Object>();      
		
		StringBuffer sql = new StringBuffer();
		sql.append("select b.seqId , userId, giftId, giftName, giftType, isValid, chargeFlag, ip, bonus, recordTime " +
				"from boxbonusproductchargerecord b left join gift g on b.productId = g.giftId where 1=1 \n");

		handleParamter(query, sql, list);
    	
        sql.append(" order by recordTime desc limit ?,?");
        list.add((pageNo-1)*pageSize);
	    list.add(pageSize);
		
      final List<BoxBonusChargeRecordDTO> bonusChargeRecordList = new ArrayList<BoxBonusChargeRecordDTO>();
      getJdbcTemplate().query(sql.toString(), list.toArray(), new RowCallbackHandler() {
          @Override
          public void processRow(ResultSet resultSet) throws SQLException {
        	  BoxBonusChargeRecordDTO bonusChargeRecord = new BoxBonusChargeRecordDTO();
        	  
        	  Long userId = resultSet.getLong("userId");
        	  bonusChargeRecord.setUserId(userId);
        	  bonusChargeRecord.setSeqId(resultSet.getLong("seqId"));
        	  bonusChargeRecord.setBonus(resultSet.getLong("bonus"));
        	  bonusChargeRecord.setChargeFlag(resultSet.getInt("chargeFlag"));
        	  bonusChargeRecord.setIp(resultSet.getString("ip"));
        	  bonusChargeRecord.setGiftId(resultSet.getString("giftId"));
        	  bonusChargeRecord.setGiftName(resultSet.getString("giftName"));
        	  bonusChargeRecord.setGiftType(resultSet.getString("giftType"));
        	  bonusChargeRecord.setIsValid(resultSet.getInt("isValid"));
        	  bonusChargeRecord.setRecordTime(resultSet.getString("recordTime"));
        	  bonusChargeRecordList.add(bonusChargeRecord);
        	  
          }
      });
      return bonusChargeRecordList;
	}
	
	@Override
	public int getCount(BoxBonusChargeRecordDTO query){
		List<Object> list = new ArrayList<Object>();  
		
		StringBuffer sql = new StringBuffer();
		sql.append("select count(*) as count " +
				"from boxbonusproductchargerecord b left join gift g on b.productId = g.giftId where 1=1 \n");

		handleParamter(query, sql, list);
      
		int counts = getJdbcTemplate().queryForInt(sql.toString(), list.toArray());
      
		return counts;
	}
	
	public List export(BoxBonusChargeRecordDTO query){
		StringBuffer sql = new StringBuffer(
				"SELECT giftrecord.userid,giftrecord.giftid,giftrecord.recordTime,g.giftName,deliveryaddress.userName,deliveryaddress.userRealName,deliveryaddress.province,deliveryaddress.city, " +
				"deliveryaddress.district,deliveryaddress.detailAddress,deliveryaddress.postCode,deliveryaddress.telephone,deliveryaddress.mobilePhone " +
				"FROM giftrecord " +
				"LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.`giftRecordId` " +
				"LEFT JOIN gift g ON giftrecord.giftId = g.giftId left join deliveryaddress on giftrecord.userid = deliveryaddress.userid " +
				"LEFT JOIN boxbonusproductchargerecord b on g.giftId = b.productId " +
				"WHERE g.giftType='product' and (giftshopreleaserecord.releaseStatus IS NULL OR giftshopreleaserecord.releaseStatus != 1) and deliveryaddress.addressid is not null "); 
		List<Object> list = new ArrayList<Object>(); 
		
		handleParamter(query, sql, list);
		
		this.baseSo = FacadeFactory.INSTANCE.getBaseSo();
 	    List<BonusChargeUserDetailDTO> listUserDetail = this.baseSo.executeQuery(BonusChargeUserDetailDTO.class, sql.toString(), list);
 	   
 	    List datas = new ArrayList();
 	    for(BonusChargeUserDetailDTO cr : listUserDetail){
 	    	List lists = new ArrayList();
 	    	lists.add(cr.getUserId());
 	    	lists.add(cr.getGiftid());
 	    	lists.add(cr.getGiftName());
 	    	lists.add(cr.getRecordTime());
 	    	lists.add(cr.getUserName());
 	    	lists.add(cr.getUserRealName());
 	    	lists.add(cr.getProvince());
 	    	lists.add(cr.getCity());
 	    	lists.add(cr.getDistrict()); 	    	
 	    	lists.add(cr.getDetailAddress());
 	    	lists.add(cr.getPostCode());
 	    	lists.add(cr.getTelephone());
 	    	lists.add(cr.getMobilePhone());
 	    	datas.add(lists);
 	    }
 	    
 	    return datas;
	}
	
	private void handleParamter(BoxBonusChargeRecordDTO query, StringBuffer sql, List<Object> list){
		Long userId = query.getUserId();
    	if(null!=userId && 0!=userId){
    		sql.append(" and  b.userId= ?")  ;
    		list.add(userId);
    	}
		
		String giftId = query.getGiftId();
    	if(StringTools.isNotEmpty(giftId)){
    		sql.append(" and  g.giftId= ?");
    		list.add(giftId);
    	}
    	
    	String giftName = query.getGiftName();
    	if(StringTools.isNotEmpty(giftName)){
    		sql.append(" and  g.giftName= ?");
    		list.add(giftName);
    	}
    	
    	Integer isValid = query.getIsValid();
    	if(!(null == isValid)){
    		sql.append(" and  g.isValid= ?");
    		list.add(isValid);
    	}
    	
    	String giftType = query.getGiftType();
    	if(StringTools.isNotEmpty(giftType)){
    		sql.append(" and  g.giftType= ?");
    		list.add(giftType);
    	}
    	
    	Long maxBonus = query.getMaxBonus();
    	if(!(null == maxBonus) && !(maxBonus==0)){
    		sql.append(" and  b.bonus<=?");
    		list.add(maxBonus);
    	}
    	
    	Long minBonus = query.getMinBonus();
    	if(null != minBonus && minBonus!=0){
    		sql.append(" and  b.bonus>=?");
    		list.add(minBonus);
    	}
    	
    	String startTime = query.getStartTime();
    	if(StringTools.isNotEmpty(startTime)){
    		sql.append(" and  b.recordTime>=?");
    		list.add(startTime);
    	}
    	
    	String endTime = query.getEndTime();
    	if(StringTools.isNotEmpty(endTime)){
    		sql.append(" and  b.recordTime<=?");
    		list.add(endTime);
    	}
    	
    	Integer chargeFlag = query.getChargeFlag();
    	if(null!=chargeFlag && 0!=chargeFlag){
    		sql.append(" and  b.chargeFlag=?");
    		list.add(chargeFlag);
    	}
    	
    	
	}
	
	
	

}
