package com.xunlei.niux.data.vipgame.bo;

import java.util.*;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.dto.RebateOrderGroupByApOrderIdDTO;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;


/**
 * 返利原始订单
 * @author lisu
 * @date 2013-12-04
 * @Descripter:
 */
public class RebateOrderBoImpl extends BaseDaoImpl implements RebateOrderBo {
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public void execute(String sql, List<Object> list) {
		baseDao.execute(sql, list);
		
	}
	public List executeQuery(Class class1, String sql, List list) {       
		return baseDao.executeQuery(class1, sql, list);
	}
	public int count(Class clazz,String sql, Object entity) {
		   Select select = new Select(entity, new Page());
	        String presql =  select.getPreSql();
	        List<Object> params = select.getParamsList();
	        if(presql.indexOf("limit") != -1){      	
	        	presql = presql.substring(0,presql.indexOf("limit"));    
	        	if(presql.indexOf("order")!=-1){
	            	presql = presql.substring(0,presql.indexOf("order"));      
	        	}	
	        }
	        if(presql.indexOf("where")==-1){
	        	presql += "   where 1=1 ";
	        }	      
	        if(!StringTools.isEmpty(sql)){
	        	presql += sql;
	        }
//	        presql = presql.replace("ap orderid", "aporderid");
	        System.out.println("presql:"+presql);
	        presql  = presql.replace("*", "count(1)");
	        int count = getJdbcTemplate().queryForInt(presql, params==null?new Object[]{}:params.toArray());
		return count;
	}
	  public List findByObject(Class clazz,String sql, Object entity, Page page) {		   
	        Select select = new Select(entity, page);
	        String presql =  select.getPreSql();
	        String limit = "limit 0,20";
	        String orderby = "";
	        if(presql.indexOf("limit") != -1){
	        	limit = presql.substring(presql.indexOf("limit"));        	
	        	presql = presql.substring(0,presql.indexOf("limit"));    
	        	if(presql.indexOf("order by")!=-1){
	            	orderby = presql.substring(presql.indexOf("order by"));
	            	presql = presql.substring(0,presql.indexOf("order by"));      
	        	}	
	        }
	        if(presql.indexOf("where")==-1){
	        	presql += "   where 1=1 ";
	        }
	      
	        if(!StringTools.isEmpty(sql)){
	        	presql += sql;
	        }
	        presql += (" "+orderby);
	        presql +=(" "+limit);
	        System.out.println("rebateapply presql:"+presql);
//	        presql = presql.replace("ap orderid", "aporderid");
	        return baseDao.executeQuery(clazz, presql, select.getParamsList());
	    }
	  
	  public List findByObject2(Class clazz,String sql, Object entity, Page page) {		   
	        Select select = new Select(entity, page);
	        String presql =  select.getPreSql();
	        String limit = "";
	        String orderby = "";
	        if(presql.indexOf("limit") != -1){
	        	limit = presql.substring(presql.indexOf("limit"));        	
	        	presql = presql.substring(0,presql.indexOf("limit"));    
	        	if(presql.indexOf("order by")!=-1){
	            	orderby = presql.substring(presql.indexOf("order by"));
	            	presql = presql.substring(0,presql.indexOf("order by"));      
	        	}	
	        }
	        if(presql.indexOf("where")==-1){
	        	presql += "   where 1=1 ";
	        }
	      
	        if(!StringTools.isEmpty(sql)){
	        	presql += sql;
	        }
	        presql += (" "+orderby);
	        presql +=(" "+limit);
	        System.out.println("rebateapply presql:"+presql);
//	        presql = presql.replace("ap orderid", "aporderid");
	        return baseDao.executeQuery(clazz, presql, select.getParamsList());
	    }

    @Override
    public Map<String, RebateOrderGroupByApOrderIdDTO> getRebateOrderMapGroupByApOrderId(Set<String> aporderidSet) {

        Map<String, RebateOrderGroupByApOrderIdDTO> roMap = new HashMap<String, RebateOrderGroupByApOrderIdDTO>();
        if(aporderidSet.isEmpty()){
            return  roMap;
        }

        String sql = "select aporderid , max(orderid) as orderid, sum(PayMoney) as totalPayMoney, sum(ConsumeMoney) as totalConsumeMoney, sum(RebateMoney) as totalRebateMoney " +
                " from rebateorder where aporderid in( :aporderids ) group by aporderid";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("aporderids", aporderidSet);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(getDataSource());
        List <RebateOrderGroupByApOrderIdDTO> roList = namedParameterJdbcTemplate.query(sql, parameters, new BeanPropertyRowMapper(RebateOrderGroupByApOrderIdDTO.class));
        for(RebateOrderGroupByApOrderIdDTO ro:roList){
            roMap.put(ro.getApOrderId(),ro);
        }
        return roMap;
    }

	@Override
	public void updateRebateApplyReaded() {
		List<Object> paramsList = new ArrayList();
		String sql = "update rebateapply set isReaded=1 where isReaded!=1  or isReaded is  NULL";
		baseDao.execute(sql,paramsList);
	}
}
