package com.xunlei.niux.data.vipgame.bo;

import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.QuestionSettings;

public class QuestionSettingsBoImpl extends BaseDaoImpl implements QuestionSettingsBo {

    private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	@Override
	public int count(QuestionSettings question) {
		return baseDao.count(question);
	}

	@Override
	public void deleteById(long id) {
		baseDao.deleteById(QuestionSettings.class, id);
	}

	@Override
	public List<QuestionSettings> find(QuestionSettings question, int pageNo,
			int pageSize) {
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		return baseDao.findByObject(QuestionSettings.class, question, page);
	}

	@Override
	public QuestionSettings findById(long id) {
		return baseDao.findById(QuestionSettings.class, id);
	}

	@Override
	public void insert(QuestionSettings question) {
		 baseDao.insert(question);
	}

	@Override
	public void update(QuestionSettings question) {
		baseDao.updateById(question);
	}
	
	public List findBySql(Class clazz, String preSql, List paramList){
		 return baseDao.findBySql(clazz, preSql, paramList);
	}
	
	public int count(String sql,Object [] args){
	    return getJdbcTemplate().queryForInt(sql, args);
	}
}
