package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.InterfaceMan;

public class InterfaceManBoImpl implements InterfaceManBo {
	
	private BaseDao baseDao;

	@Override
	public int count(InterfaceMan interfaceMan) {
		return baseDao.count(interfaceMan);
	}

	@Override
	public void delete(InterfaceMan interfaceMan) {
         this.deleteById(interfaceMan.getSeqid());
	}

	@Override
	public void deleteById(long seqid) {
		baseDao.deleteById(InterfaceMan.class, seqid);

	}

	@Override
	public List<InterfaceMan> find(InterfaceMan interfaceMan, int pageNo,int pageSize) {
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("inputtime", OrderType.DESC);
		return baseDao.findByObject(InterfaceMan.class, interfaceMan, page);
	}

	@Override
	public InterfaceMan findById(long seqid) {
		return baseDao.findById(InterfaceMan.class, seqid);
	}

	@Override
	public void insert(InterfaceMan interfaceMan) {
		baseDao.insert(interfaceMan);
	}

	@Override
	public void update(InterfaceMan interfaceMan) {
        baseDao.updateById(interfaceMan);
	}

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public List findBySql(Class clazz, String preSql, List paramList){
		 return baseDao.findBySql(clazz, preSql, paramList);
	}
}
