package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.util.ObjectMapper;
import com.xunlei.niux.data.vipgame.vo.mobile.MobileGamePushedMail;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Dean on 2016/12/12.
 */
public class MobileGamePushedMailDaoImpl extends BaseDaoImpl implements MobileGamePushedMailDao {


    public int countVailMail(String gameId,String dateTime){
        int result=0;
        StringBuffer sql=new StringBuffer();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT count(1) from mobilegamepushedmail where isTest=0 ");
        if(StringUtils.isNotEmpty(gameId)){
            sql.append(" and gameId=? ");
            args.add(gameId);
        }
        if(StringUtils.isNotEmpty(dateTime)){
            sql.append(" and outputTime<=?  ");
            args.add(dateTime);
        }
        result=getJdbcTemplate().queryForInt(sql.toString(),args.toArray());
        return result;
    }


    public List<MobileGamePushedMail> getVailMail(String gameId,String dateTime){
        StringBuffer sql=new StringBuffer();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT * from mobilegamepushedmail where isTest=0 ");
        if(StringUtils.isNotEmpty(gameId)){
            sql.append(" and gameId=? ");
            args.add(gameId);
        }
        if(StringUtils.isNotEmpty(dateTime)){
            sql.append(" and outputTime<=?  ");
            args.add(dateTime);
        }
        return getJdbcTemplate().query(sql.toString(),args.toArray(),new ObjectMapper(MobileGamePushedMail.class));
    }


    public List<MobileGamePushedMail> getVailMail(String dateTime){
        StringBuffer sql=new StringBuffer();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT * from mobilegamepushedmail where isTest=0 ");
        if(StringUtils.isNotEmpty(dateTime)){
            sql.append(" and outputTime<=?  ");
            args.add(dateTime);
        }
        sql.append(" order by  gameId ,outputTime desc");
        return getJdbcTemplate().query(sql.toString(),args.toArray(),new ObjectMapper(MobileGamePushedMail.class));
    }

}
