package com.xunlei.niux.data.vipgame.bo.moyu;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuExchange;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hezhong
 */
public class MoyuExchangeBoImpl implements MoyuExchangeBo {

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<MoyuExchange> find(MoyuExchange exchange, int start, int limit) {
        Page page = new Page();
        page.setPageNo(start);
        page.setPageSize(limit);
        page.addOrder("exchangetime", OrderType.DESC);

        return baseDao.findByObject(MoyuExchange.class, exchange, page);
    }

    @Override
    public void insert(MoyuExchange exchange) {
        baseDao.insert(exchange);
    }

    @Override
    public void update(MoyuExchange exchange) {
        baseDao.updateById(exchange);
    }

    @Override
    public void updateStatus(String orderid) {
        final String sql = "update myexchange set status = 1 where orderid = ? and status = 0 ";
        final ArrayList<Object> params = new ArrayList<Object>();
        params.add(orderid);
        baseDao.execute(sql, params);
    }
}
