/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.vic.CustomerBo;
import com.xunlei.niux.data.vipgame.dao.vic.CustomerDao;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostLoginDTO;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostPayDTO;
import com.xunlei.niux.data.vipgame.vo.GuestGrade;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class CustomerBoImpl
implements CustomerBo {
    private BaseDao baseDao;
    private CustomerDao customerDao;
    private static final String SQL_1 = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 1 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 2 DAY) AND c.lastPayTime>=(CURDATE() - INTERVAL 2 DAY)";
    private static final String SQL_2 = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  2 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime=(CURDATE() - INTERVAL 3 DAY)";
    private static final String SQL_3 = "  SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 3 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 3 DAY) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY)) ";
    private static final String SQL_4 = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 4 AS loginPayType\n FROM customerdetailquery c\n WHERE (c.lastLoginTime>=(CURDATE() - INTERVAL 7 DAY) and c.lastLoginTime<=(CURDATE() - INTERVAL 5 DAY)) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY)) ";
    private static final String SQL_5 = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  5 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime>=(CURDATE() - INTERVAL 14 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 8 DAY)";
    private static final String SQL_6 = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  6 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime<=(CURDATE() - INTERVAL 15 DAY)";

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    public CustomerDao getCustomerDao() {
        return this.customerDao;
    }

    public void setCustomerDao(CustomerDao customerDao) {
        this.customerDao = customerDao;
    }

    @Override
    public int countQueryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, GuestGrade guestGrade, Integer vipGradeFrom, Integer vipGradeTo, String customerService, Integer loginPay) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) as cnt FROM (%s) c left join guestpayamount g on c.uid=g.uid WHERE 1=1 ");
        if (StringUtils.isNotEmpty((String)lastPayGame)) {
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if (StringUtils.isNotEmpty((String)lastPayTimeFrom)) {
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if (StringUtils.isNotEmpty((String)lastPayTimeTo)) {
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if (vipGradeFrom != null && vipGradeFrom != 0) {
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if (vipGradeTo != null && vipGradeTo != 0) {
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if (StringUtils.isNotEmpty((String)customerService)) {
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if (guestGrade != null) {
            sql.append(" AND IFNULL(g.payAmount,0)>=? and IFNULL(g.payAmount,0)<=? ");
            params.add(guestGrade.getMinAmount());
            params.add(guestGrade.getMaxAmount());
        }
        String unionSql = "";
        switch (loginPay) {
            case 1: {
                unionSql = SQL_1;
                break;
            }
            case 2: {
                unionSql = SQL_2;
                break;
            }
            case 3: {
                unionSql = SQL_3;
                break;
            }
            case 4: {
                unionSql = SQL_4;
                break;
            }
            case 5: {
                unionSql = SQL_5;
                break;
            }
            case 6: {
                unionSql = SQL_6;
                break;
            }
            default: {
                unionSql = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 1 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 2 DAY) AND c.lastPayTime>=(CURDATE() - INTERVAL 2 DAY) union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  2 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime=(CURDATE() - INTERVAL 3 DAY) union   SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 3 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 3 DAY) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY))  union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 4 AS loginPayType\n FROM customerdetailquery c\n WHERE (c.lastLoginTime>=(CURDATE() - INTERVAL 7 DAY) and c.lastLoginTime<=(CURDATE() - INTERVAL 5 DAY)) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY))  union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  5 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime>=(CURDATE() - INTERVAL 14 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 8 DAY) union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  6 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime<=(CURDATE() - INTERVAL 15 DAY)";
            }
        }
        String exeSql = String.format(sql.toString(), unionSql);
        Map map = this.baseDao.findForMap(exeSql, params);
        if (map == null || map.get("cnt") == null) {
            return 0;
        }
        Number number = (Number)map.get("cnt");
        return number != null ? number.intValue() : 0;
    }

    @Override
    public List<CustomerWarningLostPayDTO> queryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, GuestGrade guestGrade, Integer vipGradeFrom, Integer vipGradeTo, String customerService, Integer loginPay, Page page) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT c.*,g.payAmount,i.lostPay,i.firstTreat,i.firstTreatResult,i.secondTreat,i.secondTreatResult FROM (%s) c left join customerinfo i on c.uid=i.uid left join guestpayamount g on c.uid=g.uid  WHERE 1=1 ");
        if (StringUtils.isNotEmpty((String)lastPayGame)) {
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if (StringUtils.isNotEmpty((String)lastPayTimeFrom)) {
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if (StringUtils.isNotEmpty((String)lastPayTimeTo)) {
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if (vipGradeFrom != null && vipGradeFrom != 0) {
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if (vipGradeTo != null && vipGradeTo != 0) {
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if (StringUtils.isNotEmpty((String)customerService)) {
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if (guestGrade != null) {
            sql.append(" AND IFNULL(g.payAmount,0)>=? and IFNULL(g.payAmount,0)<=? ");
            params.add(guestGrade.getMinAmount());
            params.add(guestGrade.getMaxAmount());
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT " + (pageNo - 1) * pageSize + ", " + pageSize);
        String unionSql = "";
        switch (loginPay) {
            case 1: {
                unionSql = SQL_1;
                break;
            }
            case 2: {
                unionSql = SQL_2;
                break;
            }
            case 3: {
                unionSql = SQL_3;
                break;
            }
            case 4: {
                unionSql = SQL_4;
                break;
            }
            case 5: {
                unionSql = SQL_5;
                break;
            }
            case 6: {
                unionSql = SQL_6;
                break;
            }
            default: {
                unionSql = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 1 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 2 DAY) AND c.lastPayTime>=(CURDATE() - INTERVAL 2 DAY) union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  2 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime=(CURDATE() - INTERVAL 3 DAY) union   SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 3 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 3 DAY) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY))  union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 4 AS loginPayType\n FROM customerdetailquery c\n WHERE (c.lastLoginTime>=(CURDATE() - INTERVAL 7 DAY) and c.lastLoginTime<=(CURDATE() - INTERVAL 5 DAY)) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY))  union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  5 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime>=(CURDATE() - INTERVAL 14 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 8 DAY) union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  6 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime<=(CURDATE() - INTERVAL 15 DAY)";
            }
        }
        String exeSql = String.format(sql.toString(), unionSql);
        return this.customerDao.queryData(exeSql, params);
    }

    @Override
    public int countQueryDataLogin(String lastLoginGame, String lastLoginTimeFrom, String lastLoginTimeTo, GuestGrade guestGrade, Integer vipGradeFrom, Integer vipGradeTo, String customerService, Integer loginPay) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) as cnt FROM (%s) c left join guestpayamount g on c.uid=g.uid WHERE 1=1 ");
        if (StringUtils.isNotEmpty((String)lastLoginGame)) {
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if (StringUtils.isNotEmpty((String)lastLoginTimeFrom)) {
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if (StringUtils.isNotEmpty((String)lastLoginTimeTo)) {
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if (vipGradeFrom != null && vipGradeFrom != 0) {
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if (vipGradeTo != null && vipGradeTo != 0) {
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if (StringUtils.isNotEmpty((String)customerService)) {
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if (guestGrade != null) {
            sql.append(" AND IFNULL(g.payAmount,0)>=? and IFNULL(g.payAmount,0)<=? ");
            params.add(guestGrade.getMinAmount());
            params.add(guestGrade.getMaxAmount());
        }
        String unionSql = "";
        switch (loginPay) {
            case 1: {
                unionSql = SQL_1;
                break;
            }
            case 2: {
                unionSql = SQL_2;
                break;
            }
            case 3: {
                unionSql = SQL_3;
                break;
            }
            case 4: {
                unionSql = SQL_4;
                break;
            }
            case 5: {
                unionSql = SQL_5;
                break;
            }
            case 6: {
                unionSql = SQL_6;
                break;
            }
            default: {
                unionSql = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 1 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 2 DAY) AND c.lastPayTime>=(CURDATE() - INTERVAL 2 DAY) union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  2 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime=(CURDATE() - INTERVAL 3 DAY) union   SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 3 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 3 DAY) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY))  union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 4 AS loginPayType\n FROM customerdetailquery c\n WHERE (c.lastLoginTime>=(CURDATE() - INTERVAL 7 DAY) and c.lastLoginTime<=(CURDATE() - INTERVAL 5 DAY)) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY))  union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  5 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime>=(CURDATE() - INTERVAL 14 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 8 DAY) union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  6 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime<=(CURDATE() - INTERVAL 15 DAY)";
            }
        }
        String exeSql = String.format(sql.toString(), unionSql);
        Map map = this.baseDao.findForMap(exeSql, params);
        if (map == null || map.get("cnt") == null) {
            return 0;
        }
        Number number = (Number)map.get("cnt");
        return number != null ? number.intValue() : 0;
    }

    @Override
    public List<CustomerWarningLostLoginDTO> queryDataLogin(String lastLoginGame, String lastLoginTimeFrom, String lastLoginTimeTo, GuestGrade guestGrade, Integer vipGradeFrom, Integer vipGradeTo, String customerService, Integer loginPay, Page page) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT c.*,i.lostLogin,i.firstTreatLogin,i.firstTreatResultLogin,i.secondTreatLogin,i.secondTreatResultLogin FROM (%s) c left join customerinfo i on c.uid=i.uid left join guestpayamount g on c.uid=g.uid  WHERE 1=1 ");
        if (StringUtils.isNotEmpty((String)lastLoginGame)) {
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if (StringUtils.isNotEmpty((String)lastLoginTimeFrom)) {
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if (StringUtils.isNotEmpty((String)lastLoginTimeTo)) {
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if (vipGradeFrom != null && vipGradeFrom != 0) {
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if (vipGradeTo != null && vipGradeTo != 0) {
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if (StringUtils.isNotEmpty((String)customerService)) {
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if (guestGrade != null) {
            sql.append(" AND IFNULL(g.payAmount,0)>=? and IFNULL(g.payAmount,0)<=? ");
            params.add(guestGrade.getMinAmount());
            params.add(guestGrade.getMaxAmount());
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT " + (pageNo - 1) * pageSize + ", " + pageSize);
        String unionSql = "";
        switch (loginPay) {
            case 1: {
                unionSql = SQL_1;
                break;
            }
            case 2: {
                unionSql = SQL_2;
                break;
            }
            case 3: {
                unionSql = SQL_3;
                break;
            }
            case 4: {
                unionSql = SQL_4;
                break;
            }
            case 5: {
                unionSql = SQL_5;
                break;
            }
            case 6: {
                unionSql = SQL_6;
                break;
            }
            default: {
                unionSql = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 1 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 2 DAY) AND c.lastPayTime>=(CURDATE() - INTERVAL 2 DAY) union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  2 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime=(CURDATE() - INTERVAL 3 DAY) union   SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 3 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 3 DAY) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY))  union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 4 AS loginPayType\n FROM customerdetailquery c\n WHERE (c.lastLoginTime>=(CURDATE() - INTERVAL 7 DAY) and c.lastLoginTime<=(CURDATE() - INTERVAL 5 DAY)) \n and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY))  union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  5 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime>=(CURDATE() - INTERVAL 14 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 8 DAY) union SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  6 AS loginPayType\n FROM customerdetailquery c\n WHERE c.lastPayTime<=(CURDATE() - INTERVAL 15 DAY)";
            }
        }
        String exeSql = String.format(sql.toString(), unionSql);
        return this.customerDao.queryDataLogin(exeSql, params);
    }

    @Override
    public Map<String, Object> getReportCustomerLoginPay(Integer loginPay, String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, String customerService) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, Integer> map1 = this.getReportCustomerLoginPayVIP(loginPay, lastPayGame, lastPayTimeFrom, lastPayTimeTo, customerService);
        Map<String, Integer> map2 = this.getReportCustomerLoginPayReason(loginPay, lastPayGame, lastPayTimeFrom, lastPayTimeTo, customerService);
        map.putAll(map1);
        map.putAll(map2);
        int lv = (Integer)map.get("lv");
        map.put("rate", 0);
        if (lv != 0) {
            BigDecimal rateb;
            BigDecimal lvb = new BigDecimal(lv);
            if (loginPay == 1) {
                int cnt = this.customerDao.countHightVipGradeWithin15Days(lastPayGame, lastPayTimeFrom, lastPayTimeTo, customerService);
                rateb = new BigDecimal(cnt);
            } else {
                rateb = new BigDecimal((Integer)map.get("total"));
            }
            map.put("rate", rateb.divide(lvb, 2, 4));
        }
        return map;
    }

    private Map<String, Integer> getReportCustomerLoginPayVIP(Integer loginPay, String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, String customerService) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Map<Integer, Integer> vipGradeMap = this.customerDao.getVipGradeGroupByLost(loginPay, lastPayGame, lastPayTimeFrom, lastPayTimeTo, customerService);
        int lv = 0;
        int mv = 0;
        int sv = 0;
        for (Map.Entry<Integer, Integer> entry : vipGradeMap.entrySet()) {
            if (entry.getKey() >= 7 && entry.getKey() <= 10) {
                lv += entry.getValue().intValue();
                continue;
            }
            if (entry.getKey() >= 3 && entry.getKey() <= 6) {
                mv += entry.getValue().intValue();
                continue;
            }
            if (entry.getKey() < 1 || entry.getKey() > 2) continue;
            sv += entry.getValue().intValue();
        }
        map.put("lv", lv);
        map.put("mv", mv);
        map.put("sv", sv);
        return map;
    }

    private Map<String, Integer> getReportCustomerLoginPayReason(Integer loginPay, String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, String customerService) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        SqlRowSet sqlRowSet = this.customerDao.getLostPayGroupByLost(loginPay, lastPayGame, lastPayTimeFrom, lastPayTimeTo, customerService);
        int dhd = 0;
        int zhyz = 0;
        int wg = 0;
        int hf = 0;
        int yxnbhl = 0;
        int wxq = 0;
        int qt = 0;
        while (sqlRowSet.next()) {
            String lostPay = sqlRowSet.getString(1);
            int cnt = sqlRowSet.getInt(2);
            if ("\u7b49\u6d3b\u52a8".equals(lostPay)) {
                dhd += cnt;
                continue;
            }
            if ("\u8d26\u53f7\u6613\u4e3b".equals(lostPay)) {
                zhyz += cnt;
                continue;
            }
            if ("\u5916\u6302".equals(lostPay)) {
                wg += cnt;
                continue;
            }
            if ("\u5408\u670d".equals(lostPay)) {
                hf += cnt;
                continue;
            }
            if ("\u6e38\u620f\u5185\u4e0d\u5408\u7406".equals(lostPay)) {
                yxnbhl += cnt;
                continue;
            }
            if ("\u65e0\u9700\u6c42".equals(lostPay)) {
                wxq += cnt;
                continue;
            }
            if (!"\u5176\u4ed6".equals(lostPay)) continue;
            qt += cnt;
        }
        map.put("dhd", dhd);
        map.put("zhyz", zhyz);
        map.put("wg", wg);
        map.put("hf", hf);
        map.put("yxnbhl", yxnbhl);
        map.put("wxq", wxq);
        map.put("qt", qt);
        map.put("total", dhd + zhyz + wg + hf + yxnbhl + wxq + qt);
        return map;
    }
}

