package com.xunlei.niux.data.vipgame.bo;

import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.CustomerGrade;


public class CustomerGradeBoImpl extends BaseDaoImpl implements CustomerGradeBo {

	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public List<CustomerGrade> findCustomerGradeList(){
		 return baseDao.findBySql(CustomerGrade.class, "select * from customergrade order by vipgrade desc");
   }
	
	public int queryForInt(String sql,Object args[]){
		return getJdbcTemplate().queryForInt(sql, args);
	}
	
	@Override
	public int count(CustomerGrade grade) {
		return baseDao.count(grade);
	}

	@Override
	public void deleteById(long id) {
		baseDao.deleteById(CustomerGrade.class, id);
	}

	@Override
	public List<CustomerGrade> find(
			CustomerGrade grade, Page page) {
		return baseDao.findByObject(CustomerGrade.class, grade, page);
	}

	@Override
	public CustomerGrade findById(long id) {
		return baseDao.findById(CustomerGrade.class, id);
	}

	@Override
	public void insert(CustomerGrade grade) {
		baseDao.insert(grade);
	}

	@Override
	public void update(CustomerGrade grade) {
		baseDao.updateById(grade);
	}
	
	public List findBySql(Class clazz, String preSql, List paramList){
		 return baseDao.findBySql(clazz, preSql, paramList);
	}

}
