package com.xunlei.niux.data.vipgame.bo.businesss;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.business.GongHuiServer;
import java.util.*;

public class GongHuiServerBoImpl extends BaseDaoImpl implements GongHuiServerBo {
	private static final int OPEN_SERVERS_NUM = 10;
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	public void execute(String sql, List<Object> list){
		baseDao.execute(sql, list);
	}

	public List<GongHuiServer> findGongHuiServer(GongHuiServer gameServrs, int pageNo,
			int pageSize) {
		Page page=new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("fenQuNum", OrderType.DESC);
		return baseDao.findByObject(GongHuiServer.class, gameServrs, page);
	}
	public int count(GongHuiServer gameServrs){
		return baseDao.count(gameServrs);
	}
	public GongHuiServer findGongHuiServerById(long seqid){
		return baseDao.findById(GongHuiServer.class, seqid);
	}
	public void update(GongHuiServer gameServrs){
		 baseDao.updateById(gameServrs);
	}
	public void insert(GongHuiServer gameServrs){
		baseDao.insert(gameServrs);
	}
	public List<GongHuiServer> find(GongHuiServer gs,Page page){
		return baseDao.findByObject(GongHuiServer.class, gs, page);
	}
	/**
	 * 获取gameid对应游戏的最新开区，如果包含测试数据isQueryTestData true;
	 * @param gameId
	 * @param isQueryTestData
	 * @return
	 */
	public GongHuiServer getLatestGongHuiServerByGameId(String gameId,boolean isQueryTestData){
		if(gameId==null||"".equals(gameId)){
			return null;
		}
		Page page=new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("openTime", OrderType.DESC);
		page.addOrder("fenQuNum", OrderType.DESC);
		GongHuiServer gameServrs=new GongHuiServer();
		gameServrs.setGameId(gameId);
		gameServrs.setOpenStatus("1");
		List<GongHuiServer> list=baseDao.findByObject(GongHuiServer.class, gameServrs, page);
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	public void delete(long seqId){
		baseDao.deleteById(GongHuiServer.class, seqId);
	}

    
    
    public List<GongHuiServer> getXmpOpenServersByFromDateAndToDate(String fromDate,boolean isSort,int limit) {
        String sql = "SELECT distinct s3.* FROM (SELECT gameidbytuijian FROM linkinfo WHERE linklocid='1260') s1 \n" +
                "INNER JOIN games s2 ON s1.gameidbytuijian=s2.gameid  INNER  JOIN GongHuiServer s3 ON s3.gameId = s2.gameId\n" +
                "WHERE (s2.clientType =0 OR s2.clientType =1) AND  s3.openTime <= ?\n" +
                "ORDER BY s3.openTime  ";
    	if(!isSort){//如果是逆序
    		sql += " desc,s3.fenQuNum desc ";
    	}else{
    		sql += " asc,s3.fenQuNum asc ";
    	}
    	sql += "  limit "+limit;
        List<Object> list = new ArrayList<Object>();
        list.add(fromDate);
        List<GongHuiServer> serversList = baseDao.executeQuery(GongHuiServer.class, sql, list);
        return serversList;
    }
    
    public List<GongHuiServer> getNewOpenServersByFromDateAndToDate(String fromDate, String toDate,boolean isSort) {
        String sql = "SELECT distinct s3.* FROM (SELECT gameidbytuijian FROM linkinfo WHERE linklocid='1260') s1 \n" +
                "INNER JOIN games s2 ON s1.gameidbytuijian=s2.gameid  INNER  JOIN GongHuiServer s3 ON s3.gameId = s2.gameId\n" +
                "WHERE (s2.clientType =0 OR s2.clientType =1) AND s3.openTime >= ? AND s3.openTime <= ?\n" +
                "ORDER BY s3.openTime  ";
    	if(!isSort){//如果是逆序
    		sql += " desc,s3.fenQuNum desc";
    	}else{
    		sql += " asc,s3.fenQuNum asc";
    	}
        List<Object> list = new ArrayList<Object>();
        list.add(fromDate+" 00:00:00");
        list.add(toDate+" 23:59:59");

        List<GongHuiServer> serversList = baseDao.executeQuery(GongHuiServer.class, sql, list);

        return serversList;
    }

}
