package com.xunlei.niux.data.vipgame.bo.bonus;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionRecord;

@Service
public class AuctionRecordBoImpl implements AuctionRecordBo {
	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Resource(name = "BaseDao")
	private BaseDao baseDao;

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public AuctionRecord insertAuctionRecord(AuctionRecord precord) {
		AuctionProduct product = lockAndFindAuctionProduct(precord.getAuctionProductId());
		// 判断积分是否游戏竞拍内，如果不在抛出异常
		checkProductCanAuctionUseTheBonusNum(product, precord.getBonusNum());
		// 获取该用户上次中标记录
		AuctionRecord userLastValidAuctionRecord = getUserLastValidAuctionRecord(precord.getUserId(),
				precord.getAuctionProductId());
		// 判断是否上次竞拍没有扣除积分，如果没有扣除直接扣除积分
		if (userLastValidAuctionRecord != null &&userLastValidAuctionRecord.getIsBidded()&& !("2").equals(userLastValidAuctionRecord.getBonusStatus())) {
			throw new NiuRuntimeException("1051", "存在待处理的单据");
		}
		// 计算本次需要扣除的积分
		int thisBonusNum =precord.getBonusNum();
		if(userLastValidAuctionRecord!=null&&userLastValidAuctionRecord.getIsBidded()){
			thisBonusNum=precord.getBonusNum() - userLastValidAuctionRecord.getBonusNum();
		}
		if (thisBonusNum <= 0) {
			throw new NiuRuntimeException("1050", "积分不能中标");
		}
		// 将上次订单设置为无效
		if (userLastValidAuctionRecord != null) {
			userLastValidAuctionRecord.setIsValid(false);
			update(userLastValidAuctionRecord);
		}
		// 插入本次订单
		AuctionRecord thisAuctionRecord = new AuctionRecord();
		thisAuctionRecord.setAuctionNo(OrderNoUtil.getOrderNo());
		thisAuctionRecord.setAuctionTime(sdf.format(new Date()));
		thisAuctionRecord.setUserId(precord.getUserId());
		thisAuctionRecord.setBonusNum(precord.getBonusNum());
		thisAuctionRecord.setThisBonusNum(thisBonusNum);
		thisAuctionRecord.setBaseUnitNum(product.getBaseUnitNum());
		thisAuctionRecord.setAuctionProductId(precord.getAuctionProductId());
		thisAuctionRecord.setProductLot(product.getProductLot() == null ? "" : product.getProductLot());
		thisAuctionRecord.setGameId(product.getGameId() == null ? "" : product.getGameId());
		thisAuctionRecord.setProductType(product.getProductType() == null ? "" : product.getProductType());
		thisAuctionRecord.setRoleId(precord.getRoleId());
		thisAuctionRecord.setRemark("");
		thisAuctionRecord.setAuctionIp(precord.getAuctionIp());
		thisAuctionRecord.setIsValid(true);
		thisAuctionRecord.setIsBidded(true);
		thisAuctionRecord.setBonusStatus("1");// 待扣除积分
		thisAuctionRecord.setGiveOutProductStatus("1");
		thisAuctionRecord.setGiveOutFailCause("");
		thisAuctionRecord.setActNo(precord.getActNo());
		thisAuctionRecord.setUserName(precord.getUserName());

		baseDao.insert(thisAuctionRecord);
		//设置中标人数和最低中标积分
		product=setBidderUserNumAndMinBiddedBonus(product);
		
		return this.findOne(thisAuctionRecord.getAuctionNo());
	}

	/**
	 * 更新积分扣除结果
	 * 
	 * @param auctionNo
	 * @param isSuccess
	 * @param msg
	 * @return
	 */
	public AuctionRecord updateConsumeBonusResult(String auctionNo, boolean isSuccess, String msg) {
		if (isSuccess) {
			return updateConsumeBonusResult_success(auctionNo);
		}
		return updateConsumeBonusResult_fail(auctionNo, msg);
	}

	public AuctionRecord updateConsumeBonusResult_success(String auctionNo) {
		AuctionRecord actionRecord = findOne(auctionNo);
		actionRecord.setBonusStatus("2");// 已扣除积分
		baseDao.updateById(actionRecord);
		AuctionProduct product = lockAndFindAuctionProduct(actionRecord.getAuctionProductId());
		product.setAuctionTimes(product.getAuctionTimes() + 1);
		baseDao.updateById(product);
		updatePassAuctionNumRecordSetNotBid(product);
		return actionRecord;
	}

	public AuctionRecord updateConsumeBonusResult_fail(String auctionNo, String msg) {
		AuctionRecord actionRecord = findOne(auctionNo);
		// 获取竞拍产品,并锁住
		AuctionProduct product = lockAndFindAuctionProduct(actionRecord.getAuctionProductId());
		// 更新自己的内容
		actionRecord.setBonusStatus("5");// 积分扣除失败
		actionRecord.setIsValid(false);
		actionRecord.setIsBidded(false);
		msg = msg == null ? "" : msg;
		msg = msg.length() > 255 ? msg.substring(0, 255) : msg;
		actionRecord.setGiveOutFailCause(msg);
		baseDao.updateById(actionRecord);

		// 将该用户上次中标记录置为有效的中标记录
		AuctionRecord userLastAuctionRecord = getUserlastAuctionRecord(actionRecord.getUserId(),
				product.getAuctionProductId());
		if (userLastAuctionRecord != null) {
			userLastAuctionRecord.setIsValid(true);
			baseDao.updateById(userLastAuctionRecord);
		}
		//设置中标人数和最低中标积分
		product=setBidderUserNumAndMinBiddedBonus(product);
		// 将超过中标数的中标记录返回积分
		updatePassAuctionNumRecordSetNotBid(product);
		return actionRecord;
	}
	public AuctionRecord getUserLastValidAndBiddedAuctionRecord(String userId, Long auctionProductId) {
		AuctionRecord query = new AuctionRecord();
		query.setUserId(userId);
		query.setAuctionProductId(auctionProductId);
		query.setIsBidded(true);
		query.setIsValid(true);
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("auctionTime", OrderType.DESC);
		List<AuctionRecord> list = finds(query, page);
		return (list == null || list.size() == 0) ? null : list.get(0);
	}
	public AuctionRecord getUserLastValidAuctionRecord(String userId, Long auctionProductId) {
		AuctionRecord query = new AuctionRecord();
		query.setUserId(userId);
		query.setAuctionProductId(auctionProductId);
		query.setIsValid(true);
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("auctionTime", OrderType.DESC);
		List<AuctionRecord> list = finds(query, page);
		return (list == null || list.size() == 0) ? null : list.get(0);
	}
	public AuctionRecord getUserLastBiddedAuctionRecord(String userId, Long auctionProductId) {
		AuctionRecord query = new AuctionRecord();
		query.setUserId(userId);
		query.setAuctionProductId(auctionProductId);
		query.setIsBidded(true);
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("auctionTime", OrderType.DESC);
		List<AuctionRecord> list = finds(query, page);
		return (list == null || list.size() == 0) ? null : list.get(0);
	}
	private AuctionProduct setBidderUserNumAndMinBiddedBonus(AuctionProduct product){
		AuctionRecord query=new AuctionRecord();
		query.setAuctionProductId(product.getAuctionProductId());
		query.setIsValid(true);
		query.setIsBidded(true);
		int count=baseDao.count(query);
		int biddedUserNum=count>product.getAuctionProductNum()?product.getAuctionProductNum():count;
		int biddedMinBonusNum=product.getBaseBonusNum();
		if(count>=product.getAuctionProductNum()){
			AuctionRecord latestAuctionRecord = findSortLastestBiddedRecord(product);
			biddedMinBonusNum=latestAuctionRecord.getBonusNum();
		}
		product.setBiddedMinBonusNum(biddedMinBonusNum);
		product.setBiddedUserNum(biddedUserNum);
		baseDao.updateById(product);
		return product;
	}
	/**
	 * 将超过中标数的
	 * 
	 * @param record
	 * @param product
	 */
	public void updatePassAuctionNumRecordSetNotBid(AuctionProduct product) {
		AuctionRecord query = new AuctionRecord();
		query.setAuctionProductId(product.getAuctionProductId());
		query.setIsValid(true);
		query.setIsBidded(true);
		query.setBonusStatus("2");// 已扣除积分的
		Page page = new Page();
		page.setPageNo(2);
		page.setPageSize(product.getAuctionProductNum());
		page.addOrder("bonusNum", OrderType.DESC);
		page.addOrder("auctionTime", OrderType.ESC);
		List<AuctionRecord> arlist = baseDao.findByObject(AuctionRecord.class, query, page);
		if (arlist == null || arlist.size() == 0) {
			return;
		}
		for (AuctionRecord ar : arlist) {
			StringBuilder sb = new StringBuilder();
			sb.append("update auctionrecord set isBidded=false,bonusStatus='3' where userId='")
					.append(ar.getUserId()).append("' and isBidded=true and auctionProductId=")
					.append(ar.getAuctionProductId());
			baseDao.execute(sb.toString(), new ArrayList<Object>());
		}
	}

	public int count(AuctionRecord record) {
		return baseDao.count(record);
	}

	public void update(AuctionRecord record) {
		baseDao.updateById(record);
	}

	/**
	 * 指定积分是否能够参与竞拍
	 * 
	 * @param product
	 * @param bonusNum
	 */
	public void checkProductCanAuctionUseTheBonusNum(AuctionProduct product, Integer bonusNum) {
		checkProudctInAuctionValidate(product);
		Integer biddedMinBonusNum=product.getBaseBonusNum();
		if (product.getBiddedUserNum().intValue()>=product.getAuctionProductNum().intValue()) {
			biddedMinBonusNum=product.getBiddedMinBonusNum()+product.getOneAddBonusNum();
		}
		if (biddedMinBonusNum.intValue() > bonusNum.intValue()) {
			throw new NiuRuntimeException("1050", "出价[" + bonusNum.intValue() + "]低于最低中标价");
		}
		if(product.getOneAddBonusNum()>0&&(bonusNum-product.getBaseBonusNum())%product.getOneAddBonusNum()>0){
			throw new NiuRuntimeException("1060","非法价格");
		}
	}

	/**
	 * 判断产品是否处于竞拍期，如果不在抛出异常
	 * 
	 * @param product
	 */
	private void checkProudctInAuctionValidate(AuctionProduct product) {
		Date now = new Date();
		String nowStr = sdf.format(now);
		if (nowStr.compareTo(product.getStartAuctionTime()) < 0) {
			throw new NiuRuntimeException("1052", "产品[" + product.getProductName() + "]竞拍未开始，开始时间["
					+ product.getStartAuctionTime() + "]");
		}
		if (nowStr.compareTo(product.getEndAuctionTime()) > 0) {
			throw new NiuRuntimeException("1053", "产品[" + product.getProductName() + "]竞拍已结束，结束时间["
					+ product.getEndAuctionTime() + "]");
		}
	}
	public AuctionRecord getUserlastAuctionRecord(String userId, Long auctionProductId) {
		AuctionRecord query = new AuctionRecord();
		query.setUserId(userId);
		query.setAuctionProductId(auctionProductId);

		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("auctionTime", OrderType.DESC);
		List<AuctionRecord> list = finds(query, page);
		return (list == null || list.size() == 0) ? null : list.get(0);
	}


	public List<AuctionRecord> finds(AuctionRecord query, Page page) {
		return baseDao.findByObject(AuctionRecord.class, query, page);
	}

	public AuctionRecord findOne(String auctionNo) {
		AuctionRecord query = new AuctionRecord();
		query.setAuctionNo(auctionNo);
		List<AuctionRecord> arlist = finds(query, new Page());
		return (arlist == null || arlist.size() == 0) ? null : arlist.get(0);
	}

	/**
	 * 获取排名最后的中标记录
	 * 
	 * @param product
	 * @return
	 */
	public AuctionRecord findSortLastestBiddedRecord(AuctionProduct product) {
		AuctionRecord query = new AuctionRecord();
		query.setAuctionProductId(product.getAuctionProductId());
		query.setIsValid(true);
		query.setIsBidded(true);
		Page page = new Page();
		page.setPageNo(product.getAuctionProductNum());
		page.setPageSize(1);
		page.addOrder("bonusNum", OrderType.DESC);
		page.addOrder("auctionTime", OrderType.ESC);
		List<AuctionRecord> list = finds(query, page);
		return (list == null || list.size() == 0) ? null : list.get(0);
	}

	public AuctionProduct lockAndFindAuctionProduct(long auctionProductId) {
		return baseDao.findById(AuctionProduct.class, auctionProductId);
	}

	/**
	 * 设置时间戳
	 * 
	 * @param seqId
	 * @return
	 */
	public long updateTimestamp(long seqId) {
		long timestamp = System.currentTimeMillis();
		AuctionRecord record = baseDao.findById(AuctionRecord.class, seqId);
		if (record.getTimestamp() != null && timestamp - record.getTimestamp().longValue() < 10000L) {
			throw new NiuRuntimeException("1059", "兑换太频繁");
		}
		record.setTimestamp(timestamp);
		baseDao.updateById(record);
		return timestamp;
	}
}
