package com.xunlei.niux.data.vipgame.dao.lottery;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.lottery.FreeLotteryChance;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: jamesjxin
 * Date: 13-12-20
 * Time: 上午11:53
 * To change this template use File | Settings | File Templates.
 */
public class FreeLotteryChanceDaoImpl extends BaseDaoImpl implements FreeLotteryChanceDao{

    @Override
    public List<FreeLotteryChance> getValidFreeLotteryChanceList(Long userId, int useFlag, String expiredDate) {

        final List<FreeLotteryChance> chanceList = new ArrayList<FreeLotteryChance>();
        if( userId <= 0){
            return chanceList;
        }

        Object[] args = null;
        StringBuilder sb = new StringBuilder();
        sb.append(" select seqid,actNo,userId,usedFlag,sourceFrom,recordTime,expiredDate from freelotterychance where 1=1  ");
        sb.append(" and userId = ? ");
        if(useFlag == 1){//未使用
            sb.append(" and usedFlag = 0 ");
        }else if(useFlag == 2){//已使用
            sb.append(" and usedFlag = 1 ");
        }

        if(StringUtils.isNotEmpty(expiredDate)){
            sb.append(" and expiredDate >= ? ");
            args = new Object[]{userId, expiredDate};
        }else {
            args = new Object[]{userId};
        }

        sb.append(" order by recordTime desc; ");


        getJdbcTemplate().query(sb.toString(),args,new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                FreeLotteryChance chance = new FreeLotteryChance();
                chance.setSeqid(resultSet.getLong("seqid"));
                chance.setActNo(resultSet.getString("actNo"));
                chance.setUserId(resultSet.getLong("userId"));
                chance.setUsedFlag(resultSet.getBoolean("usedFlag"));
                chance.setSourceFrom(resultSet.getString("sourceFrom"));
                chance.setRecordTime(resultSet.getString("recordTime"));
                chance.setExpiredDate(resultSet.getString("expiredDate"));
                chanceList.add(chance);
            }
        });


        return chanceList;  //To change body of implemented methods use File | Settings | File Templates.
    }
}
