package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dto.CanPkgMobileGame;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.dto.game.MobileGameDTO;
import com.xunlei.niux.data.vipgame.util.ObjectMapper;
import com.xunlei.niux.data.vipgame.vo.WDJMobileGameApk;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileGameChannelApk;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Dean on 2016/4/5.
 */
public class MobileGameApkDaoImpl extends BaseDaoImpl implements MobileGameApkDao{

    public List<WDJMobileGameApk> getWDJMobileGameApk(Long apkId, String gameId, String channleApkStatus,int pageNo,int pageSize){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT a.gameId,a.apkUrl,a.path,a.apkName,a.packageType,");
        sql.append(" t.channelApkId,t.apkId, t.channelId,t.channelApkName,t.packageTime,");
        sql.append(" t.downLoadLink, t.channleApkStatus,t.testUser,t.testTime,t.submitTestRemark,");
        sql.append(" t.testRemark, t.muliPhotoUrl, t.isWDJGame from mobileGameChannelApk t ");
        sql.append(" left join mobileGameApk a  on t.apkId=a.apkId");
        sql.append(" where t.isWDJGame=1 ");
        if(null!=apkId&&0!=apkId){
            sql.append("  and t.apkId=" +apkId);
        }
        if(StringUtils.isNotEmpty(gameId)){
            sql.append("  and t.channelId='"+gameId+"'");
        }
        if(StringUtils.isNotEmpty(channleApkStatus)){
            sql.append("  and t.channleApkStatus='"+channleApkStatus+"'");
        }

        if(pageSize>0){
            int pageStart=((pageNo-1)*pageSize);
            sql.append(" limit "+pageStart+","+pageSize);
        }

        return findBySql(WDJMobileGameApk.class,sql.toString());
    }

    public int countWDJMobileGameApk(Long apkId, String gameId, String channleApkStatus,int pageNo,int pageSize){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT count(1) from mobileGameChannelApk t ");
        sql.append(" left join mobileGameApk a  on t.apkId=a.apkId");
        sql.append(" where t.isWDJGame=1 ");
        if(null!=apkId&&0!=apkId){
            sql.append("  and t.apkId=" +apkId);
        }
        if(StringUtils.isNotEmpty(gameId)){
            sql.append("  and t.channelId='"+gameId+"'");
        }
        if(StringUtils.isNotEmpty(channleApkStatus)){
            sql.append("  and t.channleApkStatus='"+channleApkStatus+"'");
        }

        if(pageSize>0){
            int pageStart=((pageNo-1)*pageSize);
            sql.append(" limit "+pageStart+","+pageSize);
        }
        return getJdbcTemplate().queryForInt(sql.toString());
    }

    @Override
    public List<GameDTO> getPhoneGameDto(String gameId, String channelId){
        GameDTO gameDTO = new GameDTO();

        StringBuffer sql = new StringBuffer();
        sql.append("select * from games \n" +
                "left join \n" +
                "(select a.gameId, ca.muliPhotoUrl, ca.downLoadLink, ca.channelId, ca.muliPhotoUrl as mulPhotoUrl from mobileGameChannelApk ca\n" +
                "left join mobileGameApk a\n" +
                "on a.apkId = ca.apkId\n" +
                ")apkgame\n" +
                "on games.gameId = apkgame.gameId\n" +
                "where games.gameId=? and apkgame.channelId=?;");

        List<Object> list = new ArrayList<Object>();
        list.add(gameId);
        list.add(channelId);

        final List<GameDTO> gameList = new ArrayList<GameDTO>();

        getJdbcTemplate().query(sql.toString(), list.toArray(), new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException{
                GameDTO gameDTO = new GameDTO();

                gameDTO.setAppSize(resultSet.getString("appSize"));
                gameDTO.setDisplayOrder(resultSet.getInt("displayOrder"));
                gameDTO.setDownloadNum(resultSet.getInt("downloadNum"));
                gameDTO.setDownLoadUrl(resultSet.getString("downLoadLink"));
                gameDTO.setGameDesc(resultSet.getString("gameDesc"));
                gameDTO.setGameFeature(resultSet.getInt("gameFeature"));
                gameDTO.setGameId(resultSet.getString("gameId"));
                gameDTO.setGameName(resultSet.getString("gameName"));
                gameDTO.setGameNo(resultSet.getString("gameNo"));
                gameDTO.setHasGift(resultSet.getBoolean("hasGift"));
                gameDTO.setIsFirstPublish(resultSet.getBoolean("isFirstPublish"));
//                gameDTO.setIsHotOrNew(resultSet.getBoolean("isHotOrNew"));
                gameDTO.setMobileGameType(resultSet.getInt("mobileGameType"));
                gameDTO.setMulPhotoUrl(resultSet.getString("mulPhotoUrl"));
                gameDTO.setOfficialWebSite(resultSet.getString("officialWebSite"));
                gameDTO.setPackageName(resultSet.getString("packageName"));
                gameDTO.setPicUrl(resultSet.getString("picUrl"));
                gameDTO.setRunType(resultSet.getString("runType"));
                gameDTO.setSmallPicUrl(resultSet.getString("smallPicUrl"));
                gameDTO.setSummary(resultSet.getString("summary"));

                gameList.add(gameDTO);
            }
        });
        return gameList;
    }

    @Override
    public List<MobileGameDTO> getMobileGameDTO(String gameId, String channelId){
        MobileGameDTO gameDTO = new MobileGameDTO();

        StringBuffer sql = new StringBuffer();
        sql.append("select * from games g\n" +
                "left join commonspreadinfo c\n" +
                "on g.gameId = c.gameId\n" +
                "where c.advNo=? and g.gameId=?\n" +
                "order by c.recordTime desc");

        List<Object> list = new ArrayList<Object>();
        list.add(channelId);
        list.add(gameId);

        final List<MobileGameDTO> gameList = new ArrayList<MobileGameDTO>();

        getJdbcTemplate().query(sql.toString(), list.toArray(), new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException{
                MobileGameDTO gameDTO = new MobileGameDTO();

                gameDTO.setAppSize(resultSet.getString("appSize"));
                gameDTO.setDisplayOrder(resultSet.getInt("displayOrder"));
                gameDTO.setDownloadNum(resultSet.getInt("downloadNum"));
//                gameDTO.setDownLoadUrl(resultSet.getString("downLoadLink"));
                gameDTO.setGameDesc(resultSet.getString("gameDesc"));
                gameDTO.setGameFeature(resultSet.getInt("gameFeature"));
                gameDTO.setGameId(resultSet.getString("gameId"));
                gameDTO.setGameName(resultSet.getString("gameName"));
                gameDTO.setGameNo(resultSet.getString("gameNo"));
//                gameDTO.setIsHotOrNew(resultSet.getBoolean("isHotOrNew"));
                gameDTO.setMobileGameType(resultSet.getInt("mobileGameType"));
                gameDTO.setPackageName(resultSet.getString("packageName"));
                gameDTO.setPicUrl(resultSet.getString("picUrl"));
                gameDTO.setSmallPicUrl(resultSet.getString("smallPicUrl"));
                gameDTO.setSummary(resultSet.getString("summary"));
                gameDTO.setShortUrl(resultSet.getString("shortUrl"));
                gameDTO.setAppSize(resultSet.getString("appSize"));
                gameDTO.setMobileGameType(resultSet.getInt("mobileGameType"));

                gameList.add(gameDTO);
            }
        });
        return gameList;
    }


    public List<MobileGameChannelApk> getMobileGameChannelApk(Long apkId,String chanelIds){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT t.* from mobileGameChannelApk t ");
        sql.append(" where 1=1 ");
        if(null!=apkId&&apkId!=0){
            sql.append("  and t.apkId="+apkId);
        }
        if(StringUtils.isNotEmpty(chanelIds)){
            sql.append("   and t.channelId in ( "+chanelIds+")");
        }
        return getJdbcTemplate().query(sql.toString(),new ObjectMapper(MobileGameChannelApk.class));
    }

    public List<MobileGameChannelApk> getApkByIds(String apkIds){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT t.* from mobileGameChannelApk t where 1=1 ");
        if(StringUtils.isNotEmpty(apkIds)){
            sql.append("   and t.channelApkId in ( "+apkIds+")");
        }
        return getJdbcTemplate().query(sql.toString(),new ObjectMapper(MobileGameChannelApk.class));
    }

    public String getApkChannelsString(String gameId){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT GROUP_CONCAT(DISTINCT t.channelId) from mobileGameChannelApk t where t.apkId in (SELECT g.apkId from mobileGameApk g ");
        if(StringUtils.isNotEmpty(gameId)){
            sql.append("where g.gameId= "+gameId);
        }
        sql.append(")");
        Object obj=getJdbcTemplate().queryForObject(sql.toString(),String.class);
        if(null!=obj){
            return obj.toString();
        }
        return "";
    }

    public List<String> getApkChannels(String gameId){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT DISTINCT t.channelId from mobileGameChannelApk t where t.apkId in (SELECT g.apkId from mobileGameApk g ");
        if(StringUtils.isNotEmpty(gameId)){
            sql.append("where g.gameId= "+gameId);
        }
        sql.append(")");
        return getJdbcTemplate().queryForList(sql.toString(),String.class);
    }

    public List<CanPkgMobileGame> getCanPkgMobileGame(){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT g.gameName,g.gameNo,t.* from mobileGameApk t");
        sql.append(" LEFT JOIN games g on t.gameId=g.gameId");
        sql.append(" where t.apkStatus='3' and g.`status` in ('1','9') ");
        sql.append(" and  NOT EXISTS (select null from mobileGameApk a  where  a.apkStatus='3' and t.apkId<a.apkId  and t.gameId=a.gameId )");
        return getJdbcTemplate().query(sql.toString(),new ObjectMapper(CanPkgMobileGame.class));
    }



}
