package com.xunlei.niux.data.vipgame.bo.pay;

import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.pay.PayOrder;
import com.xunlei.niux.data.vipgame.vo.pay.RechargeRecord;

public class RechargeRecordBoImpl implements RechargeRecordBo {
	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public void update(RechargeRecord record) {
		baseDao.updateById(record);
	}

	public void insert(RechargeRecord record) {
		baseDao.insert(record);
	}

	public RechargeRecord find(Long seqId) {
		return baseDao.findById(RechargeRecord.class, seqId);
	}

	public RechargeRecord find(String rechargeNo) {
		RechargeRecord record=new RechargeRecord();
		record.setRechargeNo(rechargeNo);
		List<RechargeRecord> list=baseDao.findByObject(RechargeRecord.class, record, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}

	public int count(RechargeRecord record) {
		return baseDao.count(record);
	}

	public List<RechargeRecord> find(RechargeRecord record, Page page) {
		return baseDao.findByObject(RechargeRecord.class, record, page);
	}
	public void updateSuccessRechareg(RechargeRecord record){
		baseDao.updateById(record);
		if("3".equals(record.getRechargeStatus())&&"1".equals(record.getRechargeType())){
			PayOrder payOrder=new PayOrder();
			payOrder.setOrderNo(record.getOrderNo());
			List<PayOrder> list=baseDao.findByObject(PayOrder.class, payOrder, new Page());
			PayOrder po=list.get(0);
			po.setRechargeTime(record.getRechargeTime());
			po.setRechargeStatus("3");
			baseDao.updateById(po);
		}
	}
}
