/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.niux.data.vipgame.bo.AdviceBo;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.enums.AdviceTypeEnum;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AdviceBoImpl
implements AdviceBo {
    private BaseSo baseSo;

    public BaseSo getBaseSo() {
        return this.baseSo;
    }

    public void setBaseSo(BaseSo baseSo) {
        this.baseSo = baseSo;
    }

    @Override
    public List<Advice> find(Advice advice, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("displayOrder", OrderType.ESC);
        page.addOrder("inputTime", OrderType.DESC);
        return this.baseSo.findObjects(advice, page);
    }

    @Override
    public List<Advice> findAdvice(Advice advice, Page page) {
        return this.baseSo.findObjects(advice, page);
    }

    @Override
    public Advice findAdviceById(long seqId) {
        return this.baseSo.findById(Advice.class, seqId);
    }

    @Override
    public int count(Advice advice) {
        return this.baseSo.countObject(advice);
    }

    @Override
    public void update(Advice advice) {
        this.baseSo.updateObjectById(advice);
    }

    @Override
    public void insert(Advice advice) {
        this.baseSo.insertReturnId(advice);
    }

    @Override
    public void delete(Long seqId) {
        this.baseSo.deleteById(Advice.class, seqId);
    }

    @Override
    public void execute(String sql, List<Object> list) {
        this.baseSo.execute(sql, list);
    }

    @Override
    public List executeQuery(Class class1, String sql, List list) {
        return this.baseSo.executeQuery(class1, sql, list);
    }

    @Override
    public List<Advice> getAllAdviceByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum) {
        return this.getAdviceListByAdviceTypeOrderByPublishDateDesc(adviceTypeEnum, "", 0);
    }

    @Override
    public List<Advice> getAdviceListByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum, int limit) {
        return this.getAdviceListByAdviceTypeOrderByPublishDateDesc(adviceTypeEnum, "", limit);
    }

    @Override
    public List<Advice> getAdviceListByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum, String platformno, int limit) {
        Advice query = new Advice();
        query.setAdviceType(adviceTypeEnum.getValue());
        if (StringUtils.isNotEmpty((String)platformno)) {
            query.setPlatformno(platformno);
        }
        Page page = new Page();
        if (limit > 0) {
            page.setPageNo(1);
            page.setPageSize(limit);
        }
        page.addOrder("publishDate", OrderType.DESC);
        return this.baseSo.findObjects(query, page);
    }

    @Override
    public List<Advice> getRecentlyUpdatedAdvices() {
        String sql = "select * from advice where inputTime >= '" + DatetimeUtil.yesterday() + " 20:00:00' order by gameid, inputTime";
        this.baseSo.execute(sql, null);
        return this.baseSo.queryForList(sql, null, Advice.class);
    }

    @Override
    public Long insertReturnId(Advice advice) {
        return this.baseSo.insertReturnId(advice);
    }

    @Override
    public void updateDisplayOrderDefault(String gameId) {
        Advice advice = new Advice();
        advice.setAdviceType("3");
        advice.setGameId(gameId);
        advice.setLeRemoveFlagTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        ArrayList<Object> paramList = new ArrayList<Object>();
        String where = DaoUtil.createWhere((Object)advice, paramList);
        String sql = "update advice set displayOrder=100 " + where;
        this.baseSo.execute(sql, paramList);
    }
}

