/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao.lottery;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dao.lottery.FreeLotteryChanceDao;
import com.xunlei.niux.data.vipgame.vo.lottery.FreeLotteryChance;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

public class FreeLotteryChanceDaoImpl
extends BaseDaoImpl
implements FreeLotteryChanceDao {
    @Override
    public List<FreeLotteryChance> getValidFreeLotteryChanceList(Long userId, int useFlag, String expiredDate) {
        final ArrayList<FreeLotteryChance> chanceList = new ArrayList<FreeLotteryChance>();
        if (userId <= 0L) {
            return chanceList;
        }
        Object[] args = null;
        StringBuilder sb = new StringBuilder();
        sb.append(" select seqid,actNo,userId,usedFlag,sourceFrom,recordTime,expiredDate from freelotterychance where 1=1  ");
        sb.append(" and userId = ? ");
        if (useFlag == 1) {
            sb.append(" and usedFlag = 0 ");
        } else if (useFlag == 2) {
            sb.append(" and usedFlag = 1 ");
        }
        if (StringUtils.isNotEmpty((String)expiredDate)) {
            sb.append(" and expiredDate >= ? ");
            args = new Object[]{userId, expiredDate};
        } else {
            args = new Object[]{userId};
        }
        sb.append(" order by recordTime desc; ");
        this.getJdbcTemplate().query(sb.toString(), args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                FreeLotteryChance chance = new FreeLotteryChance();
                chance.setSeqid(resultSet.getLong("seqid"));
                chance.setActNo(resultSet.getString("actNo"));
                chance.setUserId(resultSet.getLong("userId"));
                chance.setUsedFlag(resultSet.getBoolean("usedFlag"));
                chance.setSourceFrom(resultSet.getString("sourceFrom"));
                chance.setRecordTime(resultSet.getString("recordTime"));
                chance.setExpiredDate(resultSet.getString("expiredDate"));
                chanceList.add(chance);
            }
        });
        return chanceList;
    }
}

