package com.xunlei.niux.data.vipgame.bo.vic;


import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.vic.CustomerDao;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostLoginDTO;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostPayDTO;
import com.xunlei.niux.data.vipgame.vo.GuestGrade;

public class CustomerBoImpl implements CustomerBo{

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    private CustomerDao customerDao;

    public CustomerDao getCustomerDao() {
        return customerDao;
    }

    public void setCustomerDao(CustomerDao customerDao) {
        this.customerDao = customerDao;
    }

    private final static String SQL_1 = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 1 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 2 DAY) AND c.lastPayTime>=(CURDATE() - INTERVAL 2 DAY)";

    private final static String SQL_2 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  2 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastPayTime=(CURDATE() - INTERVAL 3 DAY)";

    private final static String SQL_3 ="  SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 3 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 3 DAY) \n" +
            " and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY)) ";

    private final static String SQL_4 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 4 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE (c.lastLoginTime>=(CURDATE() - INTERVAL 7 DAY) and c.lastLoginTime<=(CURDATE() - INTERVAL 5 DAY)) \n" +
            " and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY)) ";

    private final static String SQL_5 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  5 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastPayTime>=(CURDATE() - INTERVAL 14 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 8 DAY)";

    private final static String SQL_6 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  6 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastPayTime<=(CURDATE() - INTERVAL 15 DAY)";



    @Override
    public int countQueryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,GuestGrade guestGrade,
                              Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                              Integer loginPay) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        
        sql.append( "SELECT count(*) as cnt FROM (%s) c left join guestpayamount g on c.uid=g.uid " +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if(guestGrade !=null){
        	sql.append(" AND IFNULL(g.payAmount,0)>=? and IFNULL(g.payAmount,0)<=? ");
            params.add(guestGrade.getMinAmount());
            params.add(guestGrade.getMaxAmount());
        }

        String unionSql = "";
        switch (loginPay){
            case 1:
                unionSql = SQL_1;
                break;
            case 2:
                unionSql = SQL_2;
                break;
            case 3:
                unionSql = SQL_3;
                break;
            case 4:
                unionSql = SQL_4;
                break;
            case 5:
                unionSql = SQL_5;
                break;
            case 6:
                unionSql = SQL_6;
                break;
            default:
                unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
        }
        String exeSql = String.format(sql.toString(),unionSql);
        Map<String, Object> map = baseDao.findForMap(exeSql,params);
        if(map==null || map.get("cnt")==null)return 0;
        Number number = (Number)map.get("cnt");
        return (number != null ? number.intValue() : 0);
    }

    @Override
    public List<CustomerWarningLostPayDTO> queryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,GuestGrade guestGrade,
                                                     Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                                                     Integer loginPay,Page page) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT c.*,g.payAmount,i.lostPay,i.firstTreat,i.firstTreatResult,i.secondTreat,i.secondTreatResult FROM (%s) c left join customerinfo i on c.uid=i.uid left join guestpayamount g on c.uid=g.uid " +
                " WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if(guestGrade !=null){
        	sql.append(" AND IFNULL(g.payAmount,0)>=? and IFNULL(g.payAmount,0)<=? ");
            params.add(guestGrade.getMinAmount());
            params.add(guestGrade.getMaxAmount());
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT "+(pageNo-1)*pageSize+", "+pageSize);

        String unionSql = "";
        switch (loginPay){
            case 1:
                unionSql = SQL_1;
                break;
            case 2:
                unionSql = SQL_2;
                break;
            case 3:
                unionSql = SQL_3;
                break;
            case 4:
                unionSql = SQL_4;
                break;
            case 5:
                unionSql = SQL_5;
                break;
            case 6:
                unionSql = SQL_6;
                break;
            default:
                unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
        }


        String exeSql = String.format(sql.toString(),unionSql);
        return customerDao.queryData(exeSql, params);
    }

    @Override
    public int countQueryDataLogin(String lastLoginGame,String lastLoginTimeFrom,String lastLoginTimeTo,GuestGrade guestGrade,
                              Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                              Integer loginPay) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT count(*) as cnt FROM (%s) c left join guestpayamount g on c.uid=g.uid " +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastLoginGame)){
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeFrom)){
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeTo)){
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if(guestGrade !=null){
        	sql.append(" AND IFNULL(g.payAmount,0)>=? and IFNULL(g.payAmount,0)<=? ");
            params.add(guestGrade.getMinAmount());
            params.add(guestGrade.getMaxAmount());
        }
        String unionSql = "";
        switch (loginPay){
            case 1:
                unionSql = SQL_1;
                break;
            case 2:
                unionSql = SQL_2;
                break;
            case 3:
                unionSql = SQL_3;
                break;
            case 4:
                unionSql = SQL_4;
                break;
            case 5:
                unionSql = SQL_5;
                break;
            case 6:
                unionSql = SQL_6;
                break;
            default:
                unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
        }
        String exeSql = String.format(sql.toString(),unionSql);
        Map<String, Object> map = baseDao.findForMap(exeSql,params);
        if(map==null || map.get("cnt")==null)return 0;
        Number number = (Number)map.get("cnt");
        return (number != null ? number.intValue() : 0);

    }

    @Override
    public List<CustomerWarningLostLoginDTO> queryDataLogin(String lastLoginGame,String lastLoginTimeFrom,String lastLoginTimeTo,GuestGrade guestGrade,
                                                     Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                                                     Integer loginPay,Page page) {

        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT c.*,i.lostLogin,i.firstTreatLogin,i.firstTreatResultLogin,i.secondTreatLogin,i.secondTreatResultLogin FROM (%s) c left join customerinfo i on c.uid=i.uid left join guestpayamount g on c.uid=g.uid " +
                " WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastLoginGame)){
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeFrom)){
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeTo)){
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if(guestGrade !=null){
        	sql.append(" AND IFNULL(g.payAmount,0)>=? and IFNULL(g.payAmount,0)<=? ");
            params.add(guestGrade.getMinAmount());
            params.add(guestGrade.getMaxAmount());
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT "+(pageNo-1)*pageSize+", "+pageSize);

        String unionSql = "";
        switch (loginPay){
            case 1:
                unionSql = SQL_1;
                break;
            case 2:
                unionSql = SQL_2;
                break;
            case 3:
                unionSql = SQL_3;
                break;
            case 4:
                unionSql = SQL_4;
                break;
            case 5:
                unionSql = SQL_5;
                break;
            case 6:
                unionSql = SQL_6;
                break;
            default:
                unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
        }


        String exeSql = String.format(sql.toString(),unionSql);
        return customerDao.queryDataLogin(exeSql, params);
    }

    @Override
    public Map<String, Object> getReportCustomerLoginPay(Integer loginPay, String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, String customerService) {
        Map<String,Object> map = new HashMap<String, Object>();
        Map<String,Integer> map1 = getReportCustomerLoginPayVIP(loginPay,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
        Map<String,Integer> map2 = getReportCustomerLoginPayReason(loginPay, lastPayGame, lastPayTimeFrom, lastPayTimeTo, customerService);
        map.putAll(map1);
        map.putAll(map2);
        int lv = (Integer)map.get("lv");
        map.put("rate",0);
        if(lv!=0){
            BigDecimal lvb = new BigDecimal(lv);
            BigDecimal rateb;
            if (loginPay==1) {
               int cnt = customerDao.countHightVipGradeWithin15Days(lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
                rateb = new BigDecimal(cnt);
            } else {
                rateb = new BigDecimal((Integer)map.get("total"));
            }
            map.put("rate",rateb.divide(lvb,2,BigDecimal.ROUND_HALF_UP));
        }
        return map;
    }

    private Map<String, Integer> getReportCustomerLoginPayVIP(Integer loginPay, String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, String customerService){
        Map<String,Integer> map = new HashMap<String, Integer>();
        Map<Integer,Integer> vipGradeMap = customerDao.getVipGradeGroupByLost(loginPay,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);
        int lv=0,mv=0,sv=0;
        for(Map.Entry<Integer,Integer> entry:vipGradeMap.entrySet()){
            if(entry.getKey()>=7&&entry.getKey()<=10){
                lv+=entry.getValue();
            }else if(entry.getKey()>=3&&entry.getKey()<=6){
                mv+=entry.getValue();
            }else if(entry.getKey()>=1&&entry.getKey()<=2){
                sv+=entry.getValue();
            }
        }
        map.put("lv",lv);
        map.put("mv",mv);
        map.put("sv", sv);
        return map;
    }

    /**
     * dhd-等活动
     * zhyz-账号易主
     * wg-外挂
     * hf-合服
     * yxnbhl-游戏内不合理
     * wxq-无需求
     * qt-其他
     */
    private Map<String, Integer> getReportCustomerLoginPayReason(Integer loginPay, String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, String customerService){
        Map<String,Integer> map = new HashMap<String, Integer>();
        SqlRowSet sqlRowSet = customerDao.getLostPayGroupByLost(loginPay,lastPayGame,lastPayTimeFrom,lastPayTimeTo,customerService);

        int dhd=0,zhyz=0,wg=0,hf=0,yxnbhl=0,wxq=0,qt=0;
        while (sqlRowSet.next()){
            String lostPay = sqlRowSet.getString(1);
            int cnt = sqlRowSet.getInt(2);
            if("等活动".equals(lostPay)){
                dhd+=cnt;
            }else if("账号易主".equals(lostPay)){
                zhyz+=cnt;
            }else if("外挂".equals(lostPay)){
                wg+=cnt;
            }else if("合服".equals(lostPay)){
                hf+=cnt;
            }else if("游戏内不合理".equals(lostPay)){
                yxnbhl+=cnt;
            }else if("无需求".equals(lostPay)){
                wxq+=cnt;
            }else if("其他".equals(lostPay)){
                qt+=cnt;
            }
        }
        map.put("dhd",dhd);
        map.put("zhyz",zhyz);
        map.put("wg",wg);
        map.put("hf",hf);
        map.put("yxnbhl",yxnbhl);
        map.put("wxq",wxq);
        map.put("qt", qt);
        map.put("total", dhd+zhyz+wg+hf+yxnbhl+wxq+qt);
        return map;
    }

}
